/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.AadAuthority;
import com.microsoft.identity.client.Authority;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.RequestContext;
import java.net.MalformedURLException;
import java.net.URL;

final class B2cAuthority
extends AadAuthority {
    private static final String TAG = B2cAuthority.class.getSimpleName();
    private static final int B2C_AUTHORITY_SEGMENTS_SIZE = 3;

    B2cAuthority(URL authority, boolean validateAuthority) {
        super(authority, validateAuthority);
        this.mAuthorityType = Authority.AuthorityType.B2C;
    }

    @Override
    protected URL updateAuthority(URL authority) {
        URL updateAuthority;
        String path = authority.getPath().replaceFirst("/", "");
        String[] pathSegments = path.split("/");
        if (pathSegments == null || pathSegments.length < 3) {
            throw new IllegalArgumentException("Invalid B2C authority");
        }
        try {
            updateAuthority = new URL(String.format("https://%s/%s/%s/%s", authority.getAuthority(), pathSegments[0], pathSegments[1], pathSegments[2]));
        }
        catch (MalformedURLException e) {
            Logger.errorPII(TAG, null, "Malformed authority url", e);
            throw new IllegalArgumentException("Malformed updated authority Url", e);
        }
        return updateAuthority;
    }

    @Override
    String performInstanceDiscovery(RequestContext requestContext, String userPrincipalName) throws MsalClientException {
        if (this.mValidateAuthority && !TRUSTED_HOST_SET.contains(this.mAuthorityUrl.getAuthority())) {
            Logger.error(TAG, null, "Authority validation is not supported for b2c authority.", null);
            throw new MsalClientException("authority_validation_not_supported", "Authority validation cannot be done against B2c instance.");
        }
        return this.getDefaultOpenIdConfigurationEndpoint();
    }
}

