/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.content.Intent;
import android.net.Uri;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalUtils;
import java.util.Map;

final class AuthorizationResult {
    private static final String TAG = AuthorizationResult.class.getSimpleName();
    private final String mAuthCode;
    private final String mState;
    private final AuthorizationStatus mAuthorizationStatus;
    private final String mError;
    private final String mErrorDescription;

    private AuthorizationResult(String authCode, String state) {
        this.mAuthorizationStatus = AuthorizationStatus.SUCCESS;
        this.mAuthCode = authCode;
        this.mState = state;
        this.mError = null;
        this.mErrorDescription = null;
    }

    private AuthorizationResult(AuthorizationStatus status, String error, String errorDescription) {
        this.mAuthorizationStatus = status;
        this.mError = error;
        this.mErrorDescription = errorDescription;
        this.mAuthCode = null;
        this.mState = null;
    }

    public static AuthorizationResult create(int resultCode, Intent data) {
        if (data == null) {
            return new AuthorizationResult(AuthorizationStatus.FAIL, "authorization_failed", "receives null intent");
        }
        if (resultCode == 2001) {
            Logger.verbose(TAG, null, "User cancel the request in webview.");
            return AuthorizationResult.getAuthorizationResultWithUserCancel();
        }
        if (resultCode == 2003) {
            String url = data.getStringExtra("com.microsoft.identity.client.finalUrl");
            return AuthorizationResult.parseAuthorizationResponse(url);
        }
        if (resultCode == 2002) {
            String error = data.getStringExtra("error_code");
            String errorDescription = data.getStringExtra("error_description");
            return new AuthorizationResult(AuthorizationStatus.FAIL, error, errorDescription);
        }
        return new AuthorizationResult(AuthorizationStatus.FAIL, "unknown_error", "Unknown result code [" + resultCode + "] returned from system webview.");
    }

    public static AuthorizationResult parseAuthorizationResponse(String returnUri) {
        AuthorizationResult authorizationResult;
        Uri responseUri = Uri.parse((String)returnUri);
        String result = responseUri.getQuery();
        if (MsalUtils.isEmpty(result)) {
            Logger.warning(TAG, null, "Invalid server response, empty query string from the webview redirect.");
            authorizationResult = AuthorizationResult.getAuthorizationResultWithInvalidServerResponse();
        } else {
            Map<String, String> urlParameters = MsalUtils.decodeUrlToMap(result, "&");
            if (urlParameters.containsKey("code")) {
                String state = urlParameters.get("state");
                if (MsalUtils.isEmpty(state)) {
                    Logger.warning(TAG, null, "State parameter is not returned from the webview redirect.");
                    authorizationResult = new AuthorizationResult(AuthorizationStatus.FAIL, "state_mismatch", "State is not returned");
                } else {
                    Logger.info(TAG, null, "Auth code is successfully returned from webview redirect.");
                    authorizationResult = new AuthorizationResult(urlParameters.get("code"), state);
                }
            } else if (urlParameters.containsKey("error")) {
                String error = urlParameters.get("error");
                String errorDescription = urlParameters.get("error_description");
                Logger.infoPII(TAG, null, "Error is returned from webview redirect, error: " + error + "; errorDescription: " + errorDescription);
                authorizationResult = new AuthorizationResult(AuthorizationStatus.FAIL, error, errorDescription);
            } else {
                authorizationResult = AuthorizationResult.getAuthorizationResultWithInvalidServerResponse();
            }
        }
        return authorizationResult;
    }

    String getAuthCode() {
        return this.mAuthCode;
    }

    String getState() {
        return this.mState;
    }

    AuthorizationStatus getAuthorizationStatus() {
        return this.mAuthorizationStatus;
    }

    String getError() {
        return this.mError;
    }

    String getErrorDescription() {
        return this.mErrorDescription;
    }

    static AuthorizationResult getAuthorizationResultWithInvalidServerResponse() {
        return new AuthorizationResult(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response.");
    }

    static AuthorizationResult getAuthorizationResultWithUserCancel() {
        return new AuthorizationResult(AuthorizationStatus.USER_CANCEL, "user_cancelled", "User pressed device back button to cancel the flow.");
    }

    static enum AuthorizationStatus {
        SUCCESS,
        USER_CANCEL,
        FAIL,
        INVALID_REQUEST;

    }
}

