/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.AccessTokenCacheItem;
import com.microsoft.identity.client.IdToken;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.User;
import java.util.Date;
import java.util.Set;

public final class AuthenticationResult {
    private final AccessTokenCacheItem mAccessTokenCacheItem;
    private final User mUser;
    private final String mTenantId;
    private final String mRawIdToken;
    private final String mUniqueId;

    AuthenticationResult(AccessTokenCacheItem accessTokenCacheItem) throws MsalClientException {
        this.mAccessTokenCacheItem = accessTokenCacheItem;
        this.mUser = accessTokenCacheItem.getUser();
        this.mRawIdToken = accessTokenCacheItem.getRawIdToken();
        IdToken idToken = accessTokenCacheItem.getIdToken();
        if (idToken != null) {
            this.mTenantId = idToken.getTenantId();
            this.mUniqueId = idToken.getUniqueId();
        } else {
            this.mTenantId = "";
            this.mUniqueId = "";
        }
    }

    public String getAccessToken() {
        return this.mAccessTokenCacheItem.getAccessToken();
    }

    public Date getExpiresOn() {
        return this.mAccessTokenCacheItem.getExpiresOn();
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public String getUniqueId() {
        return this.mUniqueId;
    }

    public String getIdToken() {
        return this.mRawIdToken;
    }

    public User getUser() {
        return this.mUser;
    }

    public String[] getScope() {
        Set<String> scopes = this.mAccessTokenCacheItem.getScope();
        return scopes.toArray(new String[scopes.size()]);
    }
}

