/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.client.AccessTokenCacheKey;
import com.microsoft.identity.client.BaseTokenCacheItem;
import com.microsoft.identity.client.ClientInfo;
import com.microsoft.identity.client.IdToken;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.TokenResponse;
import com.microsoft.identity.client.User;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

final class AccessTokenCacheItem
extends BaseTokenCacheItem {
    private static final int DEFAULT_EXPIRATION_BUFFER = 300;
    @SerializedName(value="authority")
    String mAuthority;
    @SerializedName(value="access_token")
    private String mAccessToken;
    @SerializedName(value="expires_on")
    private long mExpiresOn;
    @SerializedName(value="scope")
    String mScope;
    @SerializedName(value="token_type")
    String mTokenType;
    @SerializedName(value="id_token")
    String mRawIdToken;

    AccessTokenCacheItem() {
    }

    AccessTokenCacheItem(String authority, String clientId, TokenResponse response) throws MsalClientException {
        super(clientId, response.getRawClientInfo());
        this.mAuthority = authority;
        this.mAccessToken = response.getAccessToken();
        this.mExpiresOn = response.getExpiresOn().getTime();
        this.mScope = response.getScope();
        this.mTokenType = response.getTokenType();
        this.mRawIdToken = response.getRawIdToken();
        IdToken idToken = new IdToken(this.mRawIdToken);
        this.mUser = User.create(idToken, new ClientInfo(this.mRawClientInfo));
    }

    @Override
    AccessTokenCacheKey extractTokenCacheKey() {
        return AccessTokenCacheKey.createTokenCacheKey(this.mAuthority, this.mClientId, MsalUtils.getScopesAsSet(this.mScope), this.mUser);
    }

    String getAuthority() {
        return this.mAuthority;
    }

    String getAccessToken() {
        return this.mAccessToken;
    }

    Date getExpiresOn() {
        return new Date(this.mExpiresOn);
    }

    Set<String> getScope() {
        return MsalUtils.getScopesAsSet(this.mScope);
    }

    String getTokenType() {
        return this.mTokenType;
    }

    String getRawIdToken() {
        return this.mRawIdToken;
    }

    @Override
    String getRawClientInfo() {
        return this.mRawClientInfo;
    }

    boolean isExpired() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, 300);
        Date validity = calendar.getTime();
        Date expiresOn = this.getExpiresOn();
        return expiresOn != null && expiresOn.before(validity);
    }

    IdToken getIdToken() throws MsalClientException {
        return new IdToken(this.mRawIdToken);
    }
}

