/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.Authority;
import com.microsoft.identity.client.InstanceDiscoveryResponse;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalServiceException;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.Oauth2Client;
import com.microsoft.identity.client.RequestContext;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class AadAuthority
extends Authority {
    private static final String TAG = AadAuthority.class.getSimpleName();
    private static final String AAD_INSTANCE_DISCOVERY_ENDPOINT = "https://login.microsoftonline.com/common/discovery/instance";
    private static final String API_VERSION = "api-version";
    private static final String API_VERSION_VALUE = "1.0";
    private static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    static final String DEPRECATED_AAD_AUTHORITY_HOST = "login.windows.net";
    static final String AAD_AUTHORITY_HOST = "login.microsoftonline.com";
    static final String[] TRUSTED_HOSTS = new String[]{"login.microsoftonline.com", "login.chinacloudapi.cn", "login.microsoftonline.de", "login-us.microsoftonline.com"};
    static final Set<String> TRUSTED_HOST_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(TRUSTED_HOSTS)));

    AadAuthority(URL authority, boolean validateAuthority) {
        super(authority, validateAuthority);
        if (authority.getHost().equalsIgnoreCase(DEPRECATED_AAD_AUTHORITY_HOST)) {
            try {
                String hostWithPort = this.mAuthorityUrl.getAuthority().replace(DEPRECATED_AAD_AUTHORITY_HOST, AAD_AUTHORITY_HOST);
                this.mAuthorityUrl = new URL(String.format("https://%s%s", hostWithPort, this.mAuthorityUrl.getPath()));
            }
            catch (MalformedURLException e) {
                Logger.errorPII(TAG, null, "Fail to replace login.windows.net to login.microsoftonline.com", e);
                throw new IllegalArgumentException("Malformed authority url");
            }
        }
        this.mAuthorityType = Authority.AuthorityType.AAD;
    }

    @Override
    String performInstanceDiscovery(RequestContext requestContext, String userPrincipalName) throws MsalServiceException, MsalClientException {
        InstanceDiscoveryResponse response;
        Logger.infoPII(TAG, requestContext, "Passed in authority " + this.mAuthorityUrl.toString() + " is AAD authority. Start doing Instance discovery.");
        if (!this.mValidateAuthority || TRUSTED_HOST_SET.contains(this.mAuthorityUrl.getAuthority())) {
            Logger.verbose(TAG, requestContext, "Authority validation is turned off or the passed-in authority is in the trust list, skipping instance discovery.");
            return this.getDefaultOpenIdConfigurationEndpoint();
        }
        Oauth2Client oauth2Client = new Oauth2Client(requestContext);
        oauth2Client.addQueryParameter(API_VERSION, API_VERSION_VALUE);
        oauth2Client.addQueryParameter(AUTHORIZATION_ENDPOINT, this.mAuthorityUrl.toString() + "/oauth2/v2.0/authorize");
        oauth2Client.addHeader("client-request-id", requestContext.getCorrelationId().toString());
        try {
            response = oauth2Client.discoveryAADInstance(new URL(AAD_INSTANCE_DISCOVERY_ENDPOINT));
        }
        catch (MalformedURLException e) {
            throw new MsalClientException("malformed_url", "Malformed URL for instance discovery endpoint.", e);
        }
        catch (IOException ioException) {
            throw new MsalClientException("io_error", ioException.getMessage(), ioException);
        }
        if (!MsalUtils.isEmpty(response.getError())) {
            throw new MsalServiceException(response.getError(), response.getErrorDescription(), response.getHttpStatusCode(), null);
        }
        this.mIsAuthorityValidated = true;
        Logger.infoPII(TAG, requestContext, "Instance discovery succeeded. Tenant discovery endpoint is: " + response.getTenantDiscoveryEndpoint());
        return response.getTenantDiscoveryEndpoint();
    }

    @Override
    boolean existsInResolvedAuthorityCache(String userPrincipalName) {
        return RESOLVED_AUTHORITY.containsKey(this.mAuthorityUrl.toString());
    }

    @Override
    void addToResolvedAuthorityCache(String userPrincipalName) {
        RESOLVED_AUTHORITY.put(this.mAuthorityUrl.toString(), this);
    }
}

