/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.ClientInfo;
import com.microsoft.identity.client.IdToken;
import com.microsoft.identity.client.MsalUtils;

public class User {
    private String mDisplayableId;
    private String mName;
    private String mIdentityProvider;
    private String mUid;
    private String mUtid;

    User(String displayableId, String name, String identityProvider, String uid, String uTid) {
        this.mDisplayableId = displayableId;
        this.mName = name;
        this.mIdentityProvider = identityProvider;
        this.mUid = uid;
        this.mUtid = uTid;
    }

    static User create(IdToken idToken, ClientInfo clientInfo) {
        String uTid;
        String uid;
        if (clientInfo == null) {
            uid = "";
            uTid = "";
        } else {
            uid = clientInfo.getUniqueIdentifier();
            uTid = clientInfo.getUniqueTenantIdentifier();
        }
        return new User(idToken.getPreferredName(), idToken.getName(), idToken.getIssuer(), uid, uTid);
    }

    public String getDisplayableId() {
        return this.mDisplayableId;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentityProvider() {
        return this.mIdentityProvider;
    }

    public String getUserIdentifier() {
        return MsalUtils.getUniqueUserIdentifier(this.mUid, this.mUtid);
    }

    void setDisplayableId(String displayableId) {
        this.mDisplayableId = displayableId;
    }

    String getUid() {
        return this.mUid;
    }

    void setUid(String uid) {
        this.mUid = uid;
    }

    void setUtid(String uTid) {
        this.mUtid = uTid;
    }

    String getUtid() {
        return this.mUtid;
    }
}

