/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.BaseOauth2Response;
import com.microsoft.identity.client.MsalUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

final class TokenResponse
extends BaseOauth2Response {
    private final String mAccessToken;
    private final String mRawIdToken;
    private final String mRefreshToken;
    private final Date mExpiresOn;
    private final Date mExtendedExpiresOn;
    private final Date mIdTokenExpiresOn;
    private final String mScope;
    private final String mTokenType;
    private final String mRawClientInfo;
    private final String mClaims;
    private final Map<String, String> mAdditionalData = new HashMap<String, String>();

    public TokenResponse(String accessToken, String rawIdToken, String refreshToken, Date expiresOn, Date idTokenExpiresOn, Date extendedExpiresOn, String scope, String tokenType, String rawClientInfo) {
        super(null, null, 0);
        this.mClaims = null;
        this.mAccessToken = accessToken;
        this.mRawIdToken = rawIdToken;
        this.mRefreshToken = refreshToken;
        this.mExpiresOn = expiresOn;
        this.mIdTokenExpiresOn = idTokenExpiresOn;
        this.mExtendedExpiresOn = extendedExpiresOn;
        this.mScope = scope;
        this.mTokenType = tokenType;
        this.mRawClientInfo = rawClientInfo;
    }

    public TokenResponse(String error, String errorDescription, int statusCode, String claims) {
        super(error, errorDescription, statusCode);
        this.mClaims = claims;
        this.mAccessToken = null;
        this.mRefreshToken = null;
        this.mRawIdToken = null;
        this.mExpiresOn = null;
        this.mIdTokenExpiresOn = null;
        this.mExtendedExpiresOn = null;
        this.mScope = null;
        this.mTokenType = null;
        this.mRawClientInfo = null;
    }

    TokenResponse(BaseOauth2Response baseOauth2Response, String claims) {
        this(baseOauth2Response.getError(), baseOauth2Response.getErrorDescription(), baseOauth2Response.getHttpStatusCode(), claims);
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public String getRawIdToken() {
        return this.mRawIdToken;
    }

    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public Date getExpiresOn() {
        return this.mExpiresOn;
    }

    public Date getIdTokenExpiresOn() {
        return this.mIdTokenExpiresOn;
    }

    public Date getExtendedExpiresOn() {
        return this.mExtendedExpiresOn;
    }

    public String getScope() {
        return this.mScope;
    }

    public String getTokenType() {
        return this.mTokenType;
    }

    public String getClaims() {
        return this.mClaims;
    }

    public String getRawClientInfo() {
        return this.mRawClientInfo;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.mAdditionalData.putAll(additionalData);
    }

    public Map<String, String> getAdditionalData() {
        return this.mAdditionalData;
    }

    static TokenResponse createSuccessTokenResponse(Map<String, String> responseItems) {
        HashMap<String, String> additionalData = new HashMap<String, String>(responseItems);
        String tokenType = responseItems.get("token_type");
        additionalData.remove("token_type");
        String accessToken = responseItems.get("access_token");
        additionalData.remove("access_token");
        String refreshToken = responseItems.get("refresh_token");
        additionalData.remove("refresh_token");
        String scope = responseItems.get("scope");
        additionalData.remove("scope");
        String idToken = responseItems.get("id_token");
        additionalData.remove("id_token");
        Date expiresOn = MsalUtils.calculateExpiresOn(responseItems.get("expires_in"));
        additionalData.remove("expires_in");
        Date idTokenExpiresOn = MsalUtils.calculateExpiresOn(responseItems.get("id_token_expires_in"));
        additionalData.remove("id_token_expires_in");
        Date extendedExpiresOn = MsalUtils.calculateExpiresOn(responseItems.get("ext_expires_in"));
        additionalData.remove("ext_expires_in");
        String clientInfo = responseItems.get("client_info");
        additionalData.remove("client_info");
        TokenResponse tokenResponse = new TokenResponse(accessToken, idToken, refreshToken, expiresOn, idTokenExpiresOn, extendedExpiresOn, scope, tokenType, clientInfo);
        tokenResponse.setAdditionalData(additionalData);
        return tokenResponse;
    }

    static TokenResponse createFailureTokenResponse(Map<String, String> responseItems, int statusCode) {
        String claims = responseItems.get("claims");
        return new TokenResponse(BaseOauth2Response.createErrorResponse(responseItems, statusCode), claims);
    }
}

