/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.content.Context;
import android.content.SharedPreferences;
import com.microsoft.identity.client.CacheEvent;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.Telemetry;
import java.util.Collection;
import java.util.Map;

final class TokenCacheAccessor {
    private static final String TAG = TokenCacheAccessor.class.getSimpleName();
    private static final String ACCESS_TOKEN_SHARED_PREFERENCE = "com.microsoft.identity.client.token";
    private static final String REFRESH_TOKEN_SHARED_PREFERENCE = "com.microsoft.identity.client.refreshToken";
    private final Context mContext;
    private final SharedPreferences mAccessTokenSharedPreference;
    private final SharedPreferences mRefreshTokenSharedPreference;

    TokenCacheAccessor(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context");
        }
        this.mContext = context;
        this.mAccessTokenSharedPreference = this.mContext.getSharedPreferences(ACCESS_TOKEN_SHARED_PREFERENCE, 0);
        this.mRefreshTokenSharedPreference = this.mContext.getSharedPreferences(REFRESH_TOKEN_SHARED_PREFERENCE, 0);
        if (this.mAccessTokenSharedPreference == null || this.mRefreshTokenSharedPreference == null) {
            throw new IllegalStateException("Fail to create SharedPreference");
        }
    }

    private static CacheEvent.Builder createNewCacheEventBuilder(String eventName, boolean isRT) {
        CacheEvent.Builder builder = new CacheEvent.Builder(eventName);
        if (isRT) {
            builder.setIsRT(true);
        } else {
            builder.setIsAT(true);
        }
        return builder;
    }

    private static CacheEvent.Builder createAndStartNewCacheEvent(String telemetryRequestId, String eventName, boolean isRT) {
        CacheEvent.Builder cacheEventBuilder = TokenCacheAccessor.createNewCacheEventBuilder(eventName, isRT);
        Telemetry.getInstance().startEvent(telemetryRequestId, eventName);
        return cacheEventBuilder;
    }

    void saveAccessToken(String accessTokenCacheKey, String accessTokenItem, RequestContext requestContext) {
        if (MsalUtils.isEmpty(accessTokenCacheKey) || MsalUtils.isEmpty(accessTokenItem)) {
            throw new IllegalArgumentException("accessTokenCacheKey/accessTokenItem empty or null");
        }
        CacheEvent.Builder cacheEventBuilder = TokenCacheAccessor.createAndStartNewCacheEvent(requestContext.getTelemetryRequestId(), "msal.token_cache_write", false);
        SharedPreferences.Editor editor = this.mAccessTokenSharedPreference.edit();
        editor.putString(accessTokenCacheKey, accessTokenItem);
        editor.apply();
        Telemetry.getInstance().stopEvent(requestContext.getTelemetryRequestId(), cacheEventBuilder);
        Logger.verbose(TAG, requestContext, "Access token is saved into cache.");
        Logger.verbosePII(TAG, requestContext, "Access token is saved with key: " + accessTokenCacheKey);
    }

    void saveRefreshToken(String refreshTokenCacheKey, String refreshTokenItem, RequestContext requestContext) {
        if (MsalUtils.isEmpty(refreshTokenCacheKey) || MsalUtils.isEmpty(refreshTokenItem)) {
            throw new IllegalArgumentException("refreshTokenCacheKey/refreshTokenItem empty or null");
        }
        CacheEvent.Builder cacheEventBuilder = TokenCacheAccessor.createAndStartNewCacheEvent(requestContext.getTelemetryRequestId(), "msal.token_cache_write", true);
        SharedPreferences.Editor editor = this.mRefreshTokenSharedPreference.edit();
        editor.putString(refreshTokenCacheKey, refreshTokenItem);
        editor.apply();
        Telemetry.getInstance().stopEvent(requestContext.getTelemetryRequestId(), cacheEventBuilder);
        Logger.verbose(TAG, requestContext, "Refresh token is successfully saved into cache.");
        Logger.verbosePII(TAG, requestContext, "Refresh token is saved with key: " + refreshTokenCacheKey);
    }

    void deleteAccessToken(String accessTokenKey, RequestContext requestContext) {
        CacheEvent.Builder cacheEventBuilder = TokenCacheAccessor.createAndStartNewCacheEvent(requestContext.getTelemetryRequestId(), "msal.token_cache_delete", false);
        SharedPreferences.Editor editor = this.mAccessTokenSharedPreference.edit();
        editor.remove(accessTokenKey);
        editor.apply();
        Telemetry.getInstance().stopEvent(requestContext.getTelemetryRequestId(), cacheEventBuilder);
    }

    void deleteRefreshToken(String refreshTokenCacheKey, RequestContext requestContext) {
        Logger.verbose(TAG, requestContext, "Remove the given refresh token item.");
        Logger.verbosePII(TAG, requestContext, "Refresh token is deleted with key: " + refreshTokenCacheKey);
        CacheEvent.Builder cacheEventBuilder = TokenCacheAccessor.createAndStartNewCacheEvent(requestContext.getTelemetryRequestId(), "msal.token_cache_delete", true);
        SharedPreferences.Editor editor = this.mRefreshTokenSharedPreference.edit();
        editor.remove(refreshTokenCacheKey);
        editor.apply();
        Telemetry.getInstance().stopEvent(requestContext.getTelemetryRequestId(), cacheEventBuilder);
    }

    Collection<String> getAllAccessTokens(String telemetryRequestId) {
        CacheEvent.Builder cacheEventBuilder = TokenCacheAccessor.createAndStartNewCacheEvent(telemetryRequestId, "msal.token_cache_lookup", false);
        Map allAT = this.mAccessTokenSharedPreference.getAll();
        Telemetry.getInstance().stopEvent(telemetryRequestId, cacheEventBuilder);
        return allAT.values();
    }

    Collection<String> getAllRefreshTokens(String telemetryRequestId) {
        CacheEvent.Builder cacheEventBuilder = TokenCacheAccessor.createAndStartNewCacheEvent(telemetryRequestId, "msal.token_cache_lookup", true);
        Map allRTs = this.mRefreshTokenSharedPreference.getAll();
        Telemetry.getInstance().stopEvent(telemetryRequestId, cacheEventBuilder);
        return allRTs.values();
    }
}

