/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.util.Pair;
import com.microsoft.identity.client.ApiEvent;
import com.microsoft.identity.client.DefaultEvent;
import com.microsoft.identity.client.Event;
import com.microsoft.identity.client.EventDispatcher;
import com.microsoft.identity.client.IMsalEventReceiver;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.OrphanedEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class Telemetry {
    private static final String TAG = Telemetry.class.getSimpleName();
    private static final Telemetry INSTANCE = new Telemetry();
    private static boolean sDisableForTest;
    private final Map<Pair<String, String>, Long> mEventsInProgress = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, List<Event>> mCompletedEvents = Collections.synchronizedMap(new LinkedHashMap());
    private EventDispatcher mPublisher;
    private boolean mTelemetryOnFailureOnly = false;

    private Telemetry() {
    }

    static Telemetry getTestInstance() {
        return new Telemetry();
    }

    public static Telemetry getInstance() {
        return INSTANCE;
    }

    static String generateNewRequestId() {
        return UUID.randomUUID().toString();
    }

    static void disableForTest(boolean disabled) {
        sDisableForTest = disabled;
    }

    public synchronized void registerReceiver(IMsalEventReceiver receiver) {
        if (null == receiver) {
            throw new IllegalArgumentException("Receiver instance cannot be null");
        }
        if (null != this.mPublisher) {
            throw new IllegalStateException(IMsalEventReceiver.class.getSimpleName() + " instances are not swappable at this time.");
        }
        this.mPublisher = new EventDispatcher(receiver);
    }

    public void setTelemetryOnFailureOnly(boolean onFailure) {
        this.mTelemetryOnFailureOnly = onFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startEvent(String requestId, String eventName) {
        if (null == this.mPublisher || sDisableForTest) {
            return;
        }
        Telemetry telemetry = this;
        synchronized (telemetry) {
            this.mEventsInProgress.put((Pair<String, String>)new Pair((Object)requestId, (Object)eventName), System.currentTimeMillis());
        }
    }

    void stopEvent(String requestId, Event.Builder eventBuilder) {
        this.stopEvent(requestId, eventBuilder.getEventName(), eventBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopEvent(String requestId, String eventName, Event eventToStop) {
        Long eventStartTime;
        if (null == this.mPublisher || sDisableForTest) {
            return;
        }
        Pair eventKey = new Pair((Object)requestId, (Object)eventName);
        Telemetry telemetry = this;
        synchronized (telemetry) {
            eventStartTime = this.mEventsInProgress.get(eventKey);
        }
        if (null == eventStartTime) {
            Logger.warning(TAG, null, "Stop Event called without a corresponding start_event");
            return;
        }
        long startTimeL = Long.parseLong(eventStartTime.toString());
        long stopTimeL = System.currentTimeMillis();
        long diffTime = stopTimeL - startTimeL;
        String stopTime = Long.toString(stopTimeL);
        eventToStop.setProperty("msal.start_time", eventStartTime.toString());
        eventToStop.setProperty("msal.stop_time", stopTime);
        eventToStop.setProperty("msal.elapsed_time", Long.toString(diffTime));
        Telemetry telemetry2 = this;
        synchronized (telemetry2) {
            if (null == this.mCompletedEvents.get(requestId)) {
                ArrayList<Event> events = new ArrayList<Event>();
                events.add(eventToStop);
                this.mCompletedEvents.put(requestId, events);
            } else {
                this.mCompletedEvents.get(requestId).add(eventToStop);
            }
            this.mEventsInProgress.remove(eventKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(String requestId) {
        if (null == this.mPublisher) {
            return;
        }
        Telemetry telemetry = this;
        synchronized (telemetry) {
            List<Event> orphanedEvents = this.collateOrphanedEvents(requestId);
            if (null == this.mCompletedEvents.get(requestId)) {
                Logger.warning(TAG, null, "No completed Events returned for RequestId.");
                return;
            }
            this.mCompletedEvents.get(requestId).addAll(orphanedEvents);
            List<Event> eventsToFlush = this.mCompletedEvents.remove(requestId);
            if (this.mTelemetryOnFailureOnly) {
                boolean shouldRemoveEvents = false;
                for (Event event : eventsToFlush) {
                    if (!(event instanceof ApiEvent)) continue;
                    ApiEvent apiEvent = (ApiEvent)event;
                    shouldRemoveEvents = apiEvent.wasSuccessful();
                    break;
                }
                if (shouldRemoveEvents) {
                    eventsToFlush.clear();
                }
            }
            if (!eventsToFlush.isEmpty()) {
                eventsToFlush.add(0, new DefaultEvent.Builder().build());
                this.mPublisher.dispatch(eventsToFlush);
            }
        }
    }

    private List<Event> collateOrphanedEvents(String requestId) {
        ArrayList<Event> orphanedEvents = new ArrayList<Event>();
        for (Pair<String, String> key : this.mEventsInProgress.keySet()) {
            if (!((String)key.first).equals(requestId)) continue;
            String orphanedEventName = (String)key.second;
            Long orphanedEventStartTime = this.mEventsInProgress.remove(key);
            Event orphanedEvent = new OrphanedEvent.Builder(orphanedEventName, orphanedEventStartTime).build();
            orphanedEvents.add(orphanedEvent);
        }
        return orphanedEvents;
    }
}

