/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.RefreshTokenCacheItem;
import com.microsoft.identity.client.TokenCacheKey;
import com.microsoft.identity.client.User;

final class RefreshTokenCacheKey
extends TokenCacheKey<RefreshTokenCacheItem> {
    private final String mEnvironment;

    private RefreshTokenCacheKey(String environment, String clientId, String uid, String utid) {
        super(clientId, uid, utid);
        if (MsalUtils.isEmpty(environment)) {
            throw new IllegalArgumentException("environment");
        }
        this.mEnvironment = environment;
    }

    static RefreshTokenCacheKey createTokenCacheKey(String environment, String clientId, User user) {
        return new RefreshTokenCacheKey(environment, clientId, user.getUid(), user.getUtid());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MsalUtils.base64UrlEncodeToString(this.mEnvironment));
        stringBuilder.append("$");
        stringBuilder.append(MsalUtils.base64UrlEncodeToString(this.mClientId));
        stringBuilder.append("$");
        stringBuilder.append(this.mUserIdentifier);
        return stringBuilder.toString();
    }

    @Override
    public boolean matches(RefreshTokenCacheItem item) {
        return this.mEnvironment.equalsIgnoreCase(item.getEnvironment()) && this.mClientId.equalsIgnoreCase(item.getClientId()) && this.mUserIdentifier.equals(item.getUserIdentifier());
    }
}

