/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.microsoft.identity.client.ApiEvent;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.AuthenticationRequestParameters;
import com.microsoft.identity.client.AuthenticationResult;
import com.microsoft.identity.client.Authority;
import com.microsoft.identity.client.BrowserTabActivity;
import com.microsoft.identity.client.DefaultEvent;
import com.microsoft.identity.client.Defaults;
import com.microsoft.identity.client.InteractiveRequest;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalException;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.SilentRequest;
import com.microsoft.identity.client.Telemetry;
import com.microsoft.identity.client.TokenCache;
import com.microsoft.identity.client.UiBehavior;
import com.microsoft.identity.client.User;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class PublicClientApplication {
    private static final String TAG = PublicClientApplication.class.getSimpleName();
    private static final String CLIENT_ID_META_DATA = "com.microsoft.identity.client.ClientId";
    private static final String AUTHORITY_META_DATA = "com.microsoft.identity.client.Authority";
    private static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    private static final String ACCESS_NETWORK_STATE_PERMISSION = "android.permission.ACCESS_NETWORK_STATE";
    private static final String DEFAULT_AUTHORITY = "https://login.microsoftonline.com/common/";
    private final Context mAppContext;
    private final TokenCache mTokenCache;
    private String mAuthorityString;
    private String mClientId;
    private String mComponent;
    private String mRedirectUri;
    private boolean mValidateAuthority = true;
    private String mSliceParameters = "";

    public PublicClientApplication(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null.");
        }
        this.mAppContext = context;
        this.loadMetaDataFromManifest();
        this.mTokenCache = new TokenCache(this.mAppContext);
        this.initializeApplication();
    }

    public PublicClientApplication(@NonNull Context context, @NonNull String clientId) {
        if (context == null) {
            throw new IllegalArgumentException("Context is null");
        }
        if (MsalUtils.isEmpty(clientId)) {
            throw new IllegalArgumentException("client id is empty or null");
        }
        this.mAppContext = context;
        this.mTokenCache = new TokenCache(this.mAppContext);
        this.mClientId = clientId;
        this.mAuthorityString = DEFAULT_AUTHORITY;
        this.initializeApplication();
    }

    public PublicClientApplication(@NonNull Context context, @NonNull String clientId, @NonNull String authority) {
        this(context, clientId);
        if (MsalUtils.isEmpty(authority)) {
            throw new IllegalArgumentException("authority is empty or null");
        }
        this.mAuthorityString = authority;
    }

    private void initializeApplication() {
        DefaultEvent.initializeDefaults(Defaults.forApplication(this.mAppContext, this.mClientId));
        this.mRedirectUri = this.createRedirectUri(this.mClientId);
        this.validateInputParameters();
        this.checkInternetPermission();
        Logger.info(TAG, null, "Create new public client application.");
    }

    public static String getSdkVersion() {
        return "0.1.1";
    }

    public void setValidateAuthority(boolean validateAuthority) {
        this.mValidateAuthority = validateAuthority;
    }

    public void setComponent(String component) {
        this.mComponent = component;
    }

    public void setSliceParameters(String sliceParameters) {
        this.mSliceParameters = sliceParameters;
    }

    public List<User> getUsers() throws MsalClientException {
        String telemetryRequestId = Telemetry.generateNewRequestId();
        ApiEvent.Builder apiEventBuilder = new ApiEvent.Builder(telemetryRequestId);
        URL authorityURL = MsalUtils.getUrl(this.mAuthorityString);
        apiEventBuilder.setAuthority(authorityURL.getProtocol() + "://" + authorityURL.getHost());
        Telemetry.getInstance().startEvent(telemetryRequestId, apiEventBuilder.getEventName());
        List<User> users = this.mTokenCache.getUsers(Authority.createAuthority(this.mAuthorityString, this.mValidateAuthority).getAuthorityHost(), this.mClientId, new RequestContext(UUID.randomUUID(), this.mComponent, telemetryRequestId));
        apiEventBuilder.setApiCallWasSuccessful(true);
        this.stopTelemetryEventAndFlush(apiEventBuilder.build());
        return users;
    }

    public User getUser(String userIdentifier) throws MsalClientException {
        if (MsalUtils.isEmpty(userIdentifier)) {
            throw new IllegalArgumentException("Empty or null userIdentifier");
        }
        List<User> users = this.getUsers();
        for (User user : users) {
            if (!user.getUserIdentifier().equals(userIdentifier)) continue;
            return user;
        }
        return null;
    }

    public void handleInteractiveRequestRedirect(int requestCode, int resultCode, Intent data) {
        InteractiveRequest.onActivityResult(requestCode, resultCode, data);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @NonNull AuthenticationCallback callback) {
        String telemetryRequestId = Telemetry.generateNewRequestId();
        ApiEvent.Builder apiEventBuilder = this.createApiEventBuilder(telemetryRequestId, "179");
        this.acquireTokenInteractive(activity, scopes, "", UiBehavior.SELECT_ACCOUNT, "", null, "", null, this.wrapCallbackForTelemetryIntercept(apiEventBuilder, callback), telemetryRequestId, apiEventBuilder);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, String loginHint, @NonNull AuthenticationCallback callback) {
        String telemetryRequestId = Telemetry.generateNewRequestId();
        ApiEvent.Builder apiEventBuilder = this.createApiEventBuilder(telemetryRequestId, "180");
        this.acquireTokenInteractive(activity, scopes, loginHint, UiBehavior.SELECT_ACCOUNT, "", null, "", null, this.wrapCallbackForTelemetryIntercept(apiEventBuilder, callback), telemetryRequestId, apiEventBuilder);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, String loginHint, UiBehavior uiBehavior, String extraQueryParameters, @NonNull AuthenticationCallback callback) {
        String telemetryRequestId = Telemetry.generateNewRequestId();
        ApiEvent.Builder apiEventBuilder = this.createApiEventBuilder(telemetryRequestId, "181");
        this.acquireTokenInteractive(activity, scopes, loginHint, uiBehavior == null ? UiBehavior.SELECT_ACCOUNT : uiBehavior, extraQueryParameters, null, "", null, this.wrapCallbackForTelemetryIntercept(apiEventBuilder, callback), telemetryRequestId, apiEventBuilder);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, User user, UiBehavior uiBehavior, String extraQueryParameter, @NonNull AuthenticationCallback callback) {
        String telemetryRequestId = Telemetry.generateNewRequestId();
        ApiEvent.Builder apiEventBuilder = this.createApiEventBuilder(telemetryRequestId, "183");
        this.acquireTokenInteractive(activity, scopes, "", uiBehavior, extraQueryParameter, null, "", user, this.wrapCallbackForTelemetryIntercept(apiEventBuilder, callback), telemetryRequestId, apiEventBuilder);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, String loginHint, UiBehavior uiBehavior, String extraQueryParams, String[] extraScopesToConsent, String authority, @NonNull AuthenticationCallback callback) {
        String telemetryRequestId = Telemetry.generateNewRequestId();
        ApiEvent.Builder apiEventBuilder = this.createApiEventBuilder(telemetryRequestId, "182");
        this.acquireTokenInteractive(activity, scopes, loginHint, uiBehavior == null ? UiBehavior.SELECT_ACCOUNT : uiBehavior, extraQueryParams, extraScopesToConsent, authority, null, this.wrapCallbackForTelemetryIntercept(apiEventBuilder, callback), telemetryRequestId, apiEventBuilder);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, User user, UiBehavior uiBehavior, String extraQueryParams, String[] extraScopesToConsent, String authority, @NonNull AuthenticationCallback callback) {
        String telemetryRequestId = Telemetry.generateNewRequestId();
        ApiEvent.Builder apiEventBuilder = this.createApiEventBuilder(telemetryRequestId, "184");
        this.acquireTokenInteractive(activity, scopes, "", uiBehavior == null ? UiBehavior.SELECT_ACCOUNT : uiBehavior, extraQueryParams, extraScopesToConsent, authority, user, this.wrapCallbackForTelemetryIntercept(apiEventBuilder, callback), telemetryRequestId, apiEventBuilder);
    }

    public void acquireTokenSilentAsync(@NonNull String[] scopes, @NonNull User user, @NonNull AuthenticationCallback callback) {
        String telemetryRequestId = Telemetry.generateNewRequestId();
        ApiEvent.Builder apiEventBuilder = this.createApiEventBuilder(telemetryRequestId, "80");
        this.acquireTokenSilent(scopes, user, "", false, this.wrapCallbackForTelemetryIntercept(apiEventBuilder, callback), telemetryRequestId, apiEventBuilder);
    }

    public void acquireTokenSilentAsync(@NonNull String[] scopes, @NonNull User user, String authority, boolean forceRefresh, @NonNull AuthenticationCallback callback) {
        String telemetryRequestId = Telemetry.generateNewRequestId();
        ApiEvent.Builder apiEventBuilder = this.createApiEventBuilder(telemetryRequestId, "81");
        this.acquireTokenSilent(scopes, user, authority, forceRefresh, this.wrapCallbackForTelemetryIntercept(apiEventBuilder, callback), telemetryRequestId, apiEventBuilder);
    }

    public void remove(User user) {
        String telemetryRequestId = Telemetry.generateNewRequestId();
        ApiEvent.Builder apiEventBuilder = new ApiEvent.Builder(telemetryRequestId);
        URL authorityURL = MsalUtils.getUrl(this.mAuthorityString);
        apiEventBuilder.setAuthority(authorityURL.getProtocol() + "://" + authorityURL.getHost());
        Telemetry.getInstance().startEvent(telemetryRequestId, "msal.api_event");
        RequestContext requestContext = new RequestContext(UUID.randomUUID(), this.mComponent, telemetryRequestId);
        this.mTokenCache.deleteRefreshTokenByUser(user, requestContext);
        this.mTokenCache.deleteAccessTokenByUser(user, requestContext);
        apiEventBuilder.setApiCallWasSuccessful(true);
        this.stopTelemetryEventAndFlush(apiEventBuilder.build());
    }

    TokenCache getTokenCache() {
        return this.mTokenCache;
    }

    private void loadMetaDataFromManifest() {
        ApplicationInfo applicationInfo = MsalUtils.getApplicationInfo(this.mAppContext);
        if (applicationInfo == null || applicationInfo.metaData == null) {
            throw new IllegalArgumentException("No meta-data exists");
        }
        String authority = applicationInfo.metaData.getString(AUTHORITY_META_DATA);
        this.mAuthorityString = !MsalUtils.isEmpty(authority) ? authority : DEFAULT_AUTHORITY;
        String clientId = applicationInfo.metaData.getString(CLIENT_ID_META_DATA);
        if (MsalUtils.isEmpty(clientId)) {
            throw new IllegalArgumentException("client id missing from manifest");
        }
        this.mClientId = clientId;
    }

    private void validateInputParameters() {
        if (!MsalUtils.hasCustomTabRedirectActivity(this.mAppContext, this.mRedirectUri)) {
            throw new IllegalStateException("App doesn't have the correct configuration for " + BrowserTabActivity.class.getSimpleName() + ".");
        }
    }

    private void checkInternetPermission() {
        PackageManager packageManager = this.mAppContext.getPackageManager();
        if (packageManager.checkPermission(INTERNET_PERMISSION, this.mAppContext.getPackageName()) != 0 || packageManager.checkPermission(ACCESS_NETWORK_STATE_PERMISSION, this.mAppContext.getPackageName()) != 0) {
            throw new IllegalStateException("android.permission.Internet or android.permission.ACCESS_NETWORK_STATE is missing");
        }
    }

    private String createRedirectUri(String clientId) {
        return "msal" + clientId + "://auth";
    }

    private void acquireTokenInteractive(Activity activity, String[] scopes, String loginHint, UiBehavior uiBehavior, String extraQueryParams, String[] extraScopesToConsent, String authority, User user, AuthenticationCallback callback, String telemetryRequestId, ApiEvent.Builder apiEventBuilder) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        AuthenticationRequestParameters requestParameters = this.getRequestParameters(authority, scopes, loginHint, extraQueryParams, uiBehavior, user, telemetryRequestId);
        apiEventBuilder.setAuthorityType(requestParameters.getAuthority().mAuthorityType).setLoginHint(loginHint).setUiBehavior(uiBehavior.name()).setCorrelationId(requestParameters.getRequestContext().getCorrelationId());
        Logger.info(TAG, requestParameters.getRequestContext(), "Preparing a new interactive request");
        InteractiveRequest request = new InteractiveRequest(activity, requestParameters, extraScopesToConsent);
        request.getToken(callback);
    }

    private void acquireTokenSilent(String[] scopes, User user, String authority, boolean forceRefresh, AuthenticationCallback callback, String telemetryRequestId, ApiEvent.Builder apiEventBuilder) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        Authority authorityForRequest = MsalUtils.isEmpty(authority) ? Authority.createAuthority(this.mAuthorityString, this.mValidateAuthority) : Authority.createAuthority(authority, this.mValidateAuthority);
        RequestContext requestContext = new RequestContext(UUID.randomUUID(), this.mComponent, telemetryRequestId);
        Set<String> scopesAsSet = MsalUtils.convertArrayToSet(scopes);
        AuthenticationRequestParameters requestParameters = AuthenticationRequestParameters.create(authorityForRequest, this.mTokenCache, scopesAsSet, this.mClientId, this.mSliceParameters, requestContext);
        apiEventBuilder.setAuthorityType(requestParameters.getAuthority().mAuthorityType).setLoginHint(requestParameters.getLoginHint()).setCorrelationId(requestParameters.getRequestContext().getCorrelationId());
        if (null != requestParameters.getUiBehavior()) {
            apiEventBuilder.setUiBehavior(requestParameters.getUiBehavior().name());
        }
        Logger.info(TAG, requestContext, "Preparing a new silent request");
        SilentRequest request = new SilentRequest(this.mAppContext, requestParameters, forceRefresh, user);
        request.setIsAuthorityProvided(!MsalUtils.isEmpty(authority));
        request.getToken(callback);
    }

    private AuthenticationRequestParameters getRequestParameters(String authority, String[] scopes, String loginHint, String extraQueryParam, UiBehavior uiBehavior, User user, String telemetryRequestId) {
        Authority authorityForRequest = MsalUtils.isEmpty(authority) ? Authority.createAuthority(this.mAuthorityString, this.mValidateAuthority) : Authority.createAuthority(authority, this.mValidateAuthority);
        UUID correlationId = UUID.randomUUID();
        Set<String> scopesAsSet = MsalUtils.convertArrayToSet(scopes);
        return AuthenticationRequestParameters.create(authorityForRequest, this.mTokenCache, scopesAsSet, this.mClientId, this.mRedirectUri, loginHint, extraQueryParam, uiBehavior, user, this.mSliceParameters, new RequestContext(correlationId, this.mComponent, telemetryRequestId));
    }

    private ApiEvent.Builder createApiEventBuilder(String telemetryRequestId, String apiId) {
        ApiEvent.Builder eventBuilder = new ApiEvent.Builder(telemetryRequestId).setApiId(apiId).setAuthority(this.mAuthorityString);
        Telemetry.getInstance().startEvent(telemetryRequestId, "msal.api_event");
        return eventBuilder;
    }

    private AuthenticationCallback wrapCallbackForTelemetryIntercept(final ApiEvent.Builder eventBinding, final AuthenticationCallback authenticationCallback) {
        if (null == authenticationCallback) {
            throw new IllegalArgumentException("callback is null");
        }
        return new AuthenticationCallback(){

            @Override
            public void onSuccess(AuthenticationResult authenticationResult) {
                eventBinding.setApiCallWasSuccessful(true);
                PublicClientApplication.this.stopTelemetryEventAndFlush(eventBinding.build());
                authenticationCallback.onSuccess(authenticationResult);
            }

            @Override
            public void onError(MsalException exception) {
                eventBinding.setApiCallWasSuccessful(false);
                eventBinding.setApiErrorCode(exception.getErrorCode());
                PublicClientApplication.this.stopTelemetryEventAndFlush(eventBinding.build());
                authenticationCallback.onError(exception);
            }

            @Override
            public void onCancel() {
                PublicClientApplication.this.stopTelemetryEventAndFlush(eventBinding.build());
                authenticationCallback.onCancel();
            }
        };
    }

    private void stopTelemetryEventAndFlush(ApiEvent event) {
        Telemetry.getInstance().stopEvent(event.getRequestId(), event.getEventName(), event);
        Telemetry.getInstance().flush(event.getRequestId());
    }
}

