/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.Authority;
import com.microsoft.identity.client.BaseOauth2Response;
import com.microsoft.identity.client.HttpRequest;
import com.microsoft.identity.client.HttpResponse;
import com.microsoft.identity.client.InstanceDiscoveryResponse;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalServiceException;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.PlatformIdHelper;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.TenantDiscoveryResponse;
import com.microsoft.identity.client.TokenResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;

final class Oauth2Client {
    private static final String TAG = Oauth2Client.class.getSimpleName();
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_ACCEPT_VALUE = "application/json";
    static final String POST_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private final Map<String, String> mBodyParameters = new HashMap<String, String>();
    private final Map<String, String> mQueryParameters = new HashMap<String, String>();
    private final Map<String, String> mHeader = new HashMap<String, String>(PlatformIdHelper.getPlatformIdParameters());
    private final RequestContext mRequestContext;

    Oauth2Client(RequestContext requestContext) {
        this.mRequestContext = requestContext;
    }

    void addQueryParameter(String key, String value) {
        this.mQueryParameters.put(key, value);
    }

    void addBodyParameter(String key, String value) {
        this.mBodyParameters.put(key, value);
    }

    void addHeader(String key, String value) {
        this.mHeader.put(key, value);
    }

    TokenResponse getToken(Authority authority) throws IOException, MsalClientException, MsalServiceException {
        return this.executeHttpRequest("POST", authority.getTokenEndpoint(), new ParseRawJsonResponseDelegate<TokenResponse>(){

            @Override
            public TokenResponse parseSuccessRawResponse(Map<String, String> responseItems) {
                return TokenResponse.createSuccessTokenResponse(responseItems);
            }

            @Override
            public TokenResponse parseErrorRawResponse(Map<String, String> responseItems, int statusCode) {
                return TokenResponse.createFailureTokenResponse(responseItems, statusCode);
            }
        });
    }

    InstanceDiscoveryResponse discoveryAADInstance(URL instanceDiscoveryEndpoint) throws IOException, MsalClientException, MsalServiceException {
        return this.executeHttpRequest("GET", instanceDiscoveryEndpoint.toString(), new ParseRawJsonResponseDelegate<InstanceDiscoveryResponse>(){

            @Override
            public InstanceDiscoveryResponse parseSuccessRawResponse(Map<String, String> responseItems) {
                return InstanceDiscoveryResponse.createSuccessInstanceDiscoveryResponse(responseItems);
            }

            @Override
            public InstanceDiscoveryResponse parseErrorRawResponse(Map<String, String> responseItems, int statusCode) {
                return new InstanceDiscoveryResponse(BaseOauth2Response.createErrorResponse(responseItems, statusCode));
            }
        });
    }

    TenantDiscoveryResponse discoverEndpoints(URL openIdConfigurationEndpoint) throws IOException, MsalClientException, MsalServiceException {
        return this.executeHttpRequest("GET", openIdConfigurationEndpoint.toString(), new ParseRawJsonResponseDelegate<TenantDiscoveryResponse>(){

            @Override
            public TenantDiscoveryResponse parseSuccessRawResponse(Map<String, String> responseItems) {
                return TenantDiscoveryResponse.createSuccessTenantDiscoveryResponse(responseItems);
            }

            @Override
            public TenantDiscoveryResponse parseErrorRawResponse(Map<String, String> responseItems, int statusCode) {
                return new TenantDiscoveryResponse(BaseOauth2Response.createErrorResponse(responseItems, statusCode));
            }
        });
    }

    private <T extends BaseOauth2Response> T executeHttpRequest(String requestMethod, String endpoint, ParseRawJsonResponseDelegate<T> delegate) throws IOException, MsalServiceException, MsalClientException {
        URL endpointWithQP = new URL(MsalUtils.appendQueryParameterToUrl(endpoint, this.mQueryParameters));
        this.addHeader(HEADER_ACCEPT, HEADER_ACCEPT_VALUE);
        this.addHeader("return-client-request-id", "true");
        HttpResponse response = "GET".equals(requestMethod) ? HttpRequest.sendGet(endpointWithQP, this.mHeader, this.mRequestContext) : HttpRequest.sendPost(endpointWithQP, this.mHeader, this.buildRequestMessage(this.mBodyParameters), POST_CONTENT_TYPE, this.mRequestContext);
        return this.parseRawResponse(response, delegate);
    }

    private <T extends BaseOauth2Response> T parseRawResponse(HttpResponse httpResponse, ParseRawJsonResponseDelegate<T> delegate) throws MsalServiceException, MsalClientException {
        this.verifyCorrelationIdInResponseHeaders(httpResponse);
        Map<String, String> responseItems = this.parseResponseItems(httpResponse);
        Logger.info(TAG, this.mRequestContext, "Http response status code is: " + httpResponse.getStatusCode());
        Logger.verbosePII(TAG, this.mRequestContext, "HttpResponse body is: " + httpResponse.getBody());
        if (httpResponse.getStatusCode() == 200) {
            return delegate.parseSuccessRawResponse(responseItems);
        }
        return delegate.parseErrorRawResponse(responseItems, httpResponse.getStatusCode());
    }

    private Map<String, String> parseResponseItems(HttpResponse response) throws MsalServiceException, MsalClientException {
        Map<String, String> responseItems;
        if (MsalUtils.isEmpty(response.getBody())) {
            throw new MsalServiceException("service_not_available", "Empty response body", response.getStatusCode(), null);
        }
        try {
            responseItems = MsalUtils.extractJsonObjectIntoMap(response.getBody());
        }
        catch (JSONException e) {
            throw new MsalClientException("json_parse_failure", "Fail to parse JSON", e);
        }
        return responseItems;
    }

    private byte[] buildRequestMessage(Map<String, String> bodyParameters) throws UnsupportedEncodingException {
        HashSet<String> requestBodyEntries = new HashSet<String>();
        Set<Map.Entry<String, String>> bodyEntries = bodyParameters.entrySet();
        for (Map.Entry<String, String> bodyEntry : bodyEntries) {
            requestBodyEntries.add(bodyEntry.getKey() + "=" + MsalUtils.urlFormEncode(bodyEntry.getValue()));
        }
        String requestMessage = requestBodyEntries.isEmpty() ? "" : MsalUtils.convertSetToString(requestBodyEntries, "&");
        return requestMessage.getBytes("UTF_8");
    }

    private void verifyCorrelationIdInResponseHeaders(HttpResponse response) {
        UUID correlationIdInRequest = UUID.fromString(this.mHeader.get("client-request-id"));
        Map<String, List<String>> responseHeader = response.getHeaders();
        if (responseHeader == null || !responseHeader.containsKey("return-client-request-id")) {
            Logger.warning(TAG, this.mRequestContext, "Returned response doesn't have correlation id in the header.");
            return;
        }
        List<String> correlationIdsInHeader = responseHeader.get("return-client-request-id");
        if (correlationIdsInHeader == null || correlationIdsInHeader.size() == 0) {
            Logger.warning(TAG, this.mRequestContext, "Returned correlation id is empty.");
            return;
        }
        String correlationIdInHeader = correlationIdsInHeader.get(0);
        if (!MsalUtils.isEmpty(correlationIdInHeader)) {
            try {
                UUID correlationId = UUID.fromString(correlationIdInHeader);
                if (!correlationId.equals(correlationIdInRequest)) {
                    Logger.warning(TAG, this.mRequestContext, "Returned correlation is: " + correlationId + ", it doesn't match the sent in the request: " + correlationIdInRequest);
                }
            }
            catch (IllegalArgumentException e) {
                Logger.error(TAG, this.mRequestContext, "Returned correlation id is not formatted correctly", e);
            }
        }
    }

    private static interface ParseRawJsonResponseDelegate<T extends BaseOauth2Response> {
        public T parseSuccessRawResponse(Map<String, String> var1);

        public T parseErrorRawResponse(Map<String, String> var1, int var2);
    }
}

