/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.util.Base64;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalUtils;
import java.nio.charset.Charset;
import java.util.Map;
import org.json.JSONException;

final class IdToken {
    private final String mIssuer;
    private final String mObjectId;
    private final String mSubject;
    private final String mTenantId;
    private final String mVersion;
    private final String mPreferredName;
    private final String mName;
    private final String mHomeObjectId;

    IdToken(String rawIdToken) throws MsalClientException {
        if (MsalUtils.isEmpty(rawIdToken)) {
            throw new IllegalArgumentException("null or empty raw idtoken");
        }
        Map<String, String> idTokenItems = this.parseJWT(rawIdToken);
        if (idTokenItems == null || idTokenItems.isEmpty()) {
            throw new MsalClientException("invalid_jwt", "Empty Id token returned from server.");
        }
        this.mIssuer = idTokenItems.get("iss");
        this.mObjectId = idTokenItems.get("oid");
        this.mSubject = idTokenItems.get("sub");
        this.mTenantId = idTokenItems.get("tid");
        this.mVersion = idTokenItems.get("ver");
        this.mPreferredName = idTokenItems.get("preferred_username");
        this.mName = idTokenItems.get("name");
        this.mHomeObjectId = idTokenItems.get("home_oid");
    }

    String getIssuer() {
        return this.mIssuer;
    }

    String getObjectId() {
        return this.mObjectId;
    }

    String getSubject() {
        return this.mSubject;
    }

    String getTenantId() {
        return this.mTenantId;
    }

    String getVersion() {
        return this.mVersion;
    }

    String getPreferredName() {
        return this.mPreferredName;
    }

    String getName() {
        return this.mName;
    }

    String getHomeObjectId() {
        return this.mHomeObjectId;
    }

    String getUniqueId() {
        return this.mObjectId == null ? this.mSubject : this.mObjectId;
    }

    private Map<String, String> parseJWT(String idToken) throws MsalClientException {
        String idTokenBody = this.extractJWTBody(idToken);
        byte[] data = Base64.decode((String)idTokenBody, (int)8);
        try {
            String decodedBody = new String(data, Charset.forName("UTF_8"));
            return MsalUtils.extractJsonObjectIntoMap(decodedBody);
        }
        catch (JSONException e) {
            throw new MsalClientException("invalid_jwt", "Failed to extract Json object " + e.getMessage(), e);
        }
    }

    private String extractJWTBody(String idToken) throws MsalClientException {
        int firstDot = idToken.indexOf(".");
        int secondDot = idToken.indexOf(".", firstDot + 1);
        int invalidDot = idToken.indexOf(".", secondDot + 1);
        if (invalidDot == -1 && firstDot > 0 && secondDot > 0) {
            return idToken.substring(firstDot + 1, secondDot);
        }
        throw new MsalClientException("invalid_jwt", "Failed to parse id token.", null);
    }

    private static class IdTokenClaim {
        static final String ISSUER = "iss";
        static final String OBJECT_ID = "oid";
        static final String SUBJECT = "sub";
        static final String TENANT_ID = "tid";
        static final String VERSION = "ver";
        static final String PREFERRED_USERNAME = "preferred_username";
        static final String NAME = "name";
        static final String HOME_OBJECT_ID = "home_oid";

        private IdTokenClaim() {
        }
    }
}

