/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.util.Pair;
import com.microsoft.identity.client.Event;
import com.microsoft.identity.client.IMsalEventReceiver;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class EventDispatcher {
    private final IMsalEventReceiver mEventReceiver;

    EventDispatcher(IMsalEventReceiver receiver) {
        this.mEventReceiver = receiver;
    }

    IMsalEventReceiver getReceiver() {
        return this.mEventReceiver;
    }

    void dispatch(List<Event> eventsToPublish) {
        if (null == this.mEventReceiver) {
            return;
        }
        ArrayList<Map<String, String>> eventsForPublication = new ArrayList<Map<String, String>>();
        for (Event event : eventsToPublish) {
            LinkedHashMap<Object, Object> eventProperties = new LinkedHashMap<Object, Object>();
            for (Pair property : event) {
                eventProperties.put(property.first, property.second);
            }
            eventsForPublication.add(eventProperties);
        }
        this.mEventReceiver.onEventsReceived(eventsForPublication);
    }
}

