/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.util.Pair;
import com.microsoft.identity.client.MsalUtils;
import java.util.ArrayList;

class Event
extends ArrayList<Pair<String, String>> {
    Event(Builder builder) {
        if (null == builder.mEventName) {
            throw new IllegalStateException("Event must have a name");
        }
        if (!"msal.default".equals(builder.mEventName)) {
            this.setProperty("msal.event_name", builder.mEventName);
        }
    }

    void setProperty(String propertyName, String propertyValue) {
        if (!MsalUtils.isEmpty(propertyName) && !MsalUtils.isEmpty(propertyValue)) {
            this.add(new Pair((Object)propertyName, (Object)propertyValue));
        }
    }

    String getProperty(String propertyName) {
        String propertyValue = null;
        for (Pair property : this) {
            if (!((String)property.first).equals(propertyName)) continue;
            propertyValue = (String)property.second;
            break;
        }
        return propertyValue;
    }

    int getPropertyCount() {
        return this.size();
    }

    String getEventName() {
        return this.getProperty("msal.event_name");
    }

    static abstract class Builder<T extends Builder> {
        private final String mEventName;

        Builder(String name) {
            this.mEventName = name;
        }

        final String getEventName() {
            return this.mEventName;
        }

        abstract Event build();
    }
}

