/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.provider.Settings;
import com.microsoft.identity.client.MsalUtils;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

final class Defaults {
    final String mApplicationName;
    final String mApplicationVersion;
    final String mClientId;
    final String mDeviceId;
    final String mSdkVersion;
    final String mSdkPlatform;

    Defaults(String applicationName, String applicationVersion, String clientId, String deviceId, String sdkVersion, String sdkPlatform) {
        this.mApplicationName = applicationName;
        this.mApplicationVersion = applicationVersion;
        this.mClientId = clientId;
        this.mDeviceId = deviceId;
        this.mSdkVersion = sdkVersion;
        this.mSdkPlatform = sdkPlatform;
    }

    @SuppressLint(value={"HardwareIds"})
    static Defaults forApplication(Context context, String clientId) {
        String deviceId;
        String applicationVersion;
        String applicationName = context.getPackageName();
        String sdkVersion = "0.1.1";
        String sdkPlatform = "MSAL.Android";
        try {
            String versionName = context.getPackageManager().getPackageInfo((String)applicationName, (int)0).versionName;
            applicationVersion = null == versionName ? "NA" : versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationVersion = "NA";
        }
        try {
            deviceId = MsalUtils.createHash(Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            deviceId = "";
        }
        return new Defaults(applicationName, applicationVersion, clientId, deviceId, "0.1.1", "MSAL.Android");
    }
}

