/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.AbstractMetadataRequestor;
import com.microsoft.identity.client.DrsMetadata;
import com.microsoft.identity.client.HttpRequest;
import com.microsoft.identity.client.HttpResponse;
import com.microsoft.identity.client.IdentityProviderService;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalServiceException;
import com.microsoft.identity.client.RequestContext;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

class DRSMetadataRequestor
extends AbstractMetadataRequestor<DrsMetadata, String> {
    private static final String TAG = DRSMetadataRequestor.class.getSimpleName();
    private static final String DRS_URL_PREFIX = "https://enterpriseregistration.";
    private static final String CLOUD_RESOLVER_DOMAIN = "windows.net/";

    DRSMetadataRequestor(RequestContext requestContext) {
        super(requestContext);
    }

    @Override
    public DrsMetadata requestMetadata(String domain) throws MsalClientException, MsalServiceException {
        try {
            return this.requestOnPrem(domain);
        }
        catch (UnknownHostException e) {
            return this.requestCloud(domain);
        }
    }

    private DrsMetadata requestOnPrem(String domain) throws UnknownHostException, MsalClientException, MsalServiceException {
        Logger.verbose(TAG, this.getRequestContext(), "Requesting DRS discovery (on-prem)");
        return this.requestDrsDiscoveryInternal(Type.ON_PREM, domain);
    }

    private DrsMetadata requestCloud(String domain) throws MsalClientException, MsalServiceException {
        Logger.verbose(TAG, this.getRequestContext(), "Requesting DRS discovery (cloud)");
        try {
            return this.requestDrsDiscoveryInternal(Type.CLOUD, domain);
        }
        catch (UnknownHostException e) {
            throw new MsalClientException("io_error", "Cannot resolve the host. ", e);
        }
    }

    private DrsMetadata requestDrsDiscoveryInternal(Type type, String domain) throws UnknownHostException, MsalClientException, MsalServiceException {
        DrsMetadata metadata;
        URL requestURL;
        try {
            requestURL = new URL(this.buildRequestUrlByType(type, domain));
        }
        catch (MalformedURLException e) {
            throw new MsalClientException("unsupported_url", "Drs metadata url is invalid", e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        if (null != this.getRequestContext().getCorrelationId()) {
            headers.put("client-request-id", this.getRequestContext().getCorrelationId().toString());
        }
        try {
            HttpResponse webResponse = HttpRequest.sendGet(requestURL, headers, this.getRequestContext());
            int statusCode = webResponse.getStatusCode();
            if (200 != statusCode) {
                throw new MsalServiceException("service_not_available", "Unexpected error code: [" + webResponse.getBody() + "]", webResponse.getStatusCode(), null);
            }
            metadata = this.parseMetadata(webResponse);
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MsalClientException("io_error", "Unexpected error", e);
        }
        return metadata;
    }

    String buildRequestUrlByType(Type type, String domain) {
        StringBuilder requestUrl = new StringBuilder(DRS_URL_PREFIX);
        if (Type.CLOUD == type) {
            requestUrl.append(CLOUD_RESOLVER_DOMAIN).append(domain);
        } else if (Type.ON_PREM == type) {
            requestUrl.append(domain);
        }
        requestUrl.append("/enrollmentserver/contract?api-version=1.0");
        String requestUrlStr = requestUrl.toString();
        Logger.verbose(TAG, this.getRequestContext(), "Requestor will use DRS url: " + requestUrlStr);
        return requestUrlStr;
    }

    @Override
    DrsMetadata parseMetadata(HttpResponse response) throws MsalClientException {
        DrsMetadata drsMetadata = new DrsMetadata();
        drsMetadata.setIdentityProviderService(new IdentityProviderService());
        String responseBody = response.getBody();
        try {
            JSONObject responseJson = new JSONObject(responseBody);
            JSONObject identityProviderService = responseJson.getJSONObject("IdentityProviderService");
            String passiveAuthEndpoint = identityProviderService.getString("PassiveAuthEndpoint");
            drsMetadata.getIdentityProviderService().setPassiveAuthEndpoint(passiveAuthEndpoint);
        }
        catch (JSONException e) {
            throw new MsalClientException("json_parse_failure", "Failed to parse the Json response", e);
        }
        return drsMetadata;
    }

    static enum Type {
        ON_PREM,
        CLOUD;

    }
}

