/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.AadAuthority;
import com.microsoft.identity.client.B2cAuthority;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalServiceException;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.Oauth2Client;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.TenantDiscoveryResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class Authority {
    private static final String TAG = Authority.class.getSimpleName();
    private static final String HTTPS_PROTOCOL = "https";
    static final ConcurrentMap<String, Authority> RESOLVED_AUTHORITY = new ConcurrentHashMap<String, Authority>();
    static final String DEFAULT_OPENID_CONFIGURATION_ENDPOINT = "/v2.0/.well-known/openid-configuration";
    static final String DEFAULT_AUTHORIZE_ENDPOINT = "/oauth2/v2.0/authorize";
    static final String[] TENANTLESS_TENANT_NAME = new String[]{"common", "organizations"};
    static final String ADFS_AUTHORITY_PREFIX = "adfs";
    static final String B2C_AUTHORITY_PREFIX = "tfp";
    final boolean mValidateAuthority;
    URL mAuthorityUrl;
    boolean mIsTenantless;
    String mAuthorizationEndpoint;
    String mTokenEndpoint;
    AuthorityType mAuthorityType;
    boolean mIsAuthorityValidated = false;

    abstract String performInstanceDiscovery(RequestContext var1, String var2) throws MsalClientException, MsalServiceException;

    abstract boolean existsInResolvedAuthorityCache(String var1);

    abstract void addToResolvedAuthorityCache(String var1);

    static Authority createAuthority(String authorityUrl, boolean validateAuthority) {
        URL authority;
        try {
            authority = new URL(authorityUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("malformed authority url.", e);
        }
        if (!HTTPS_PROTOCOL.equalsIgnoreCase(authority.getProtocol())) {
            throw new IllegalArgumentException("Invalid protocol for the authority url.");
        }
        if (MsalUtils.isEmpty(authority.getPath().replace("/", ""))) {
            throw new IllegalArgumentException("Invalid authority url");
        }
        String[] pathSegments = authority.getPath().replaceFirst("/", "").split("/");
        boolean isAdfsAuthority = pathSegments[0].equals(ADFS_AUTHORITY_PREFIX);
        boolean isB2cAuthority = pathSegments[0].equals(B2C_AUTHORITY_PREFIX);
        if (isAdfsAuthority) {
            Logger.error(TAG, null, "ADFS authority is not a supported authority instance", null);
            throw new IllegalArgumentException("ADFS authority is not a supported authority instance");
        }
        if (isB2cAuthority) {
            Logger.info(TAG, null, "Passed in authority string is a b2c authority, create a new b2c authority instance.");
            return new B2cAuthority(authority, validateAuthority);
        }
        Logger.info(TAG, null, "Passed in authority string is an aad authority, create a new aad authority instance.");
        return new AadAuthority(authority, validateAuthority);
    }

    void resolveEndpoints(RequestContext requestContext, String userPrincipalName) throws MsalClientException, MsalServiceException {
        TenantDiscoveryResponse tenantDiscoveryResponse;
        Logger.info(TAG, requestContext, "Perform authority validation and tenant discovery.");
        if (this.existsInResolvedAuthorityCache(userPrincipalName)) {
            Logger.info(TAG, requestContext, "Authority has already been resolved. ");
            Authority preValidatedAuthority = (Authority)RESOLVED_AUTHORITY.get(this.mAuthorityUrl.toString());
            if (!this.mValidateAuthority || preValidatedAuthority.mIsAuthorityValidated) {
                this.mAuthorizationEndpoint = preValidatedAuthority.mAuthorizationEndpoint;
                this.mTokenEndpoint = preValidatedAuthority.mTokenEndpoint;
                return;
            }
            Logger.info(TAG, requestContext, "Authority has not been validated, need to perform authority validation first.");
        }
        String openIdConfigurationEndpoint = this.performInstanceDiscovery(requestContext, userPrincipalName);
        try {
            Oauth2Client oauth2Client = new Oauth2Client(requestContext);
            oauth2Client.addHeader("client-request-id", requestContext.getCorrelationId().toString());
            tenantDiscoveryResponse = oauth2Client.discoverEndpoints(new URL(openIdConfigurationEndpoint));
        }
        catch (IOException ioException) {
            throw new MsalClientException("io_error", ioException.getMessage(), ioException);
        }
        if (MsalUtils.isEmpty(tenantDiscoveryResponse.getAuthorizationEndpoint()) || MsalUtils.isEmpty(tenantDiscoveryResponse.getTokenEndpoint())) {
            if (tenantDiscoveryResponse.getError() != null) {
                throw new MsalServiceException(tenantDiscoveryResponse.getError(), tenantDiscoveryResponse.getErrorDescription(), tenantDiscoveryResponse.getHttpStatusCode(), null);
            }
            throw new MsalServiceException("unknown_error", "Didn't receive either success or failure response from server", tenantDiscoveryResponse.getHttpStatusCode(), null);
        }
        this.mAuthorizationEndpoint = tenantDiscoveryResponse.getAuthorizationEndpoint();
        this.mTokenEndpoint = tenantDiscoveryResponse.getTokenEndpoint();
        this.addToResolvedAuthorityCache(userPrincipalName);
    }

    protected Authority(URL authorityUrl, boolean validateAuthority) {
        this.mAuthorityUrl = this.updateAuthority(authorityUrl);
        this.mValidateAuthority = validateAuthority;
        this.mIsTenantless = this.isTenantLess();
    }

    String getAuthority() {
        return this.mAuthorityUrl.toString();
    }

    String getAuthorityHost() {
        return this.mAuthorityUrl.getHost();
    }

    String getDefaultOpenIdConfigurationEndpoint() {
        return this.mAuthorityUrl.toString() + DEFAULT_OPENID_CONFIGURATION_ENDPOINT;
    }

    String getAuthorizeEndpoint() {
        return this.mAuthorizationEndpoint;
    }

    String getTokenEndpoint() {
        return this.mTokenEndpoint;
    }

    protected URL updateAuthority(URL authority) {
        URL updatedAuthority;
        String path;
        int indexOfSecondPath = (path = authority.getPath().replaceFirst("/", "")).indexOf("/");
        String firstPath = path.substring(0, indexOfSecondPath == -1 ? path.length() : indexOfSecondPath);
        String updatedAuthorityUrl = String.format("https://%s/%s", authority.getAuthority(), firstPath);
        try {
            updatedAuthority = new URL(updatedAuthorityUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed updated authority url.", e);
        }
        return updatedAuthority;
    }

    boolean getIsTenantless() {
        return this.mIsTenantless;
    }

    void updateTenantLessAuthority(String tenantId) throws MsalClientException {
        if (!this.mIsTenantless || MsalUtils.isEmpty(tenantId)) {
            return;
        }
        List<String> tenantLessNameList = Arrays.asList(TENANTLESS_TENANT_NAME);
        String authorityString = this.mAuthorityUrl.toString();
        for (String name : tenantLessNameList) {
            authorityString = authorityString.replace(name, tenantId);
        }
        try {
            this.mAuthorityUrl = new URL(authorityString);
            this.mIsTenantless = false;
        }
        catch (MalformedURLException e) {
            throw new MsalClientException("malformed_url", "Fail to update tenant id for tenant less authority, ", e);
        }
    }

    private boolean isTenantLess() {
        String[] pathSegments = this.mAuthorityUrl.getPath().replaceFirst("/", "").split("/");
        String tenant = pathSegments[0];
        List<String> tenantLessNames = Arrays.asList(TENANTLESS_TENANT_NAME);
        return tenantLessNames.contains(tenant);
    }

    static enum AuthorityType {
        AAD,
        ADFS,
        B2C;

    }
}

