/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.Authority;
import com.microsoft.identity.client.Event;
import com.microsoft.identity.client.HttpEvent;
import com.microsoft.identity.client.IdToken;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalUtils;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

final class ApiEvent
extends Event {
    private static final String TAG = ApiEvent.class.getSimpleName();

    private ApiEvent(Builder builder) {
        super(builder);
        if (null != builder.mCorrelationId) {
            this.setProperty("msal.correlation_id", builder.mCorrelationId.toString());
        }
        if (null != builder.mRequestId) {
            this.setProperty("msal.request_id", builder.mRequestId);
        }
        this.setProperty("msal.authority", HttpEvent.sanitizeUrlForTelemetry(builder.mAuthority));
        this.setAuthorityType(builder.mAuthorityType);
        this.setProperty("msal.ui_behavior", builder.mUiBehavior);
        this.setProperty("msal.api_id", builder.mApiId);
        this.setProperty("msal.authority_validation_status", builder.mValidationStatus);
        this.setIdToken(builder.mRawIdToken);
        this.setLoginHint(builder.mLoginHint);
        this.setProperty("msal.is_successful", String.valueOf(builder.mWasApiCallSuccessful));
        this.setProperty("msal.api_error_code", builder.mApiErrorCode);
    }

    private void setAuthorityType(Authority.AuthorityType type) {
        String authorityType;
        if (type == null) {
            return;
        }
        switch (type) {
            case AAD: {
                authorityType = "aad";
                break;
            }
            case ADFS: {
                authorityType = "adfs";
                break;
            }
            case B2C: {
                authorityType = "b2c";
                break;
            }
            default: {
                authorityType = "unknown";
            }
        }
        this.setProperty("msal.authority_type", authorityType);
    }

    private void setLoginHint(String loginHint) {
        try {
            this.setProperty("msal.login_hint", MsalUtils.createHash(loginHint));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            Logger.info(TAG, null, "Skipping telemetry for LOGIN_HINT");
        }
    }

    private void setIdToken(String rawIdToken) {
        IdToken idToken;
        if (MsalUtils.isEmpty(rawIdToken)) {
            return;
        }
        try {
            idToken = new IdToken(rawIdToken);
        }
        catch (MsalClientException ae) {
            return;
        }
        this.setProperty("msal.idp", idToken.getIssuer());
        try {
            this.setProperty("msal.tenant_id", MsalUtils.createHash(idToken.getTenantId()));
            this.setProperty("msal.user_id", MsalUtils.createHash(idToken.getPreferredName()));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            Logger.info(TAG, null, "Skipping TENANT_ID and USER_ID");
        }
    }

    String getAuthority() {
        return this.getProperty("msal.authority");
    }

    String getUiBehavior() {
        return this.getProperty("msal.ui_behavior");
    }

    String getApiId() {
        return this.getProperty("msal.api_id");
    }

    String getValidationStatus() {
        return this.getProperty("msal.authority_validation_status");
    }

    String getIdpName() {
        return this.getProperty("msal.idp");
    }

    String getTenantId() {
        return this.getProperty("msal.tenant_id");
    }

    String getUserId() {
        return this.getProperty("msal.user_id");
    }

    String getLoginHint() {
        return this.getProperty("msal.login_hint");
    }

    Boolean wasSuccessful() {
        return Boolean.valueOf(this.getProperty("msal.is_successful"));
    }

    String getRequestId() {
        return this.getProperty("msal.request_id");
    }

    String getAuthorityType() {
        return this.getProperty("msal.authority_type");
    }

    String getApiErrorCode() {
        return this.getProperty("msal.api_error_code");
    }

    static class Builder
    extends Event.Builder<Builder> {
        private String mAuthority;
        private Authority.AuthorityType mAuthorityType;
        private String mUiBehavior;
        private String mApiId;
        private String mValidationStatus;
        private String mRawIdToken;
        private String mLoginHint;
        private boolean mWasApiCallSuccessful;
        private UUID mCorrelationId;
        private String mRequestId;
        private String mApiErrorCode;

        Builder(String requestId) {
            super("msal.api_event");
            this.mRequestId = requestId;
        }

        Builder setAuthority(String authority) {
            this.mAuthority = authority;
            return this;
        }

        Builder setAuthorityType(Authority.AuthorityType authorityType) {
            this.mAuthorityType = authorityType;
            return this;
        }

        Builder setUiBehavior(String uiBehavior) {
            this.mUiBehavior = uiBehavior;
            return this;
        }

        Builder setApiId(String apiId) {
            this.mApiId = apiId;
            return this;
        }

        Builder setValidationStatus(String validationStatus) {
            this.mValidationStatus = validationStatus;
            return this;
        }

        Builder setRawIdToken(String rawIdToken) {
            this.mRawIdToken = rawIdToken;
            return this;
        }

        Builder setLoginHint(String loginHint) {
            this.mLoginHint = loginHint;
            return this;
        }

        Builder setApiCallWasSuccessful(boolean callWasSuccessful) {
            this.mWasApiCallSuccessful = callWasSuccessful;
            return this;
        }

        Builder setCorrelationId(UUID correlationId) {
            this.mCorrelationId = correlationId;
            return this;
        }

        Builder setApiErrorCode(String errorCode) {
            this.mApiErrorCode = errorCode;
            return this;
        }

        @Override
        ApiEvent build() {
            return new ApiEvent(this);
        }
    }
}

