/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.microsoft.identity.client.AdfsWebFingerValidator;
import com.microsoft.identity.client.Authority;
import com.microsoft.identity.client.DRSMetadataRequestor;
import com.microsoft.identity.client.DrsMetadata;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalServiceException;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.WebFingerMetadata;
import com.microsoft.identity.client.WebFingerMetadataRequestParameters;
import com.microsoft.identity.client.WebFingerMetadataRequestor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

final class AdfsAuthority
extends Authority {
    private static final int DELIM_NOT_FOUND = -1;
    private static final String UPN_DOMAIN_SUFFIX_DELIM = "@";
    private final Set<String> mADFSValidatedAuthorities = Collections.synchronizedSet(new HashSet());

    protected AdfsAuthority(URL authorityUrl, boolean validateAuthority) {
        super(authorityUrl, validateAuthority);
        this.mAuthorityType = Authority.AuthorityType.ADFS;
    }

    @Override
    boolean existsInResolvedAuthorityCache(String userPrincipalName) {
        if (MsalUtils.isEmpty(userPrincipalName)) {
            throw new IllegalArgumentException("userPrincipalName cannot be null or blank");
        }
        ConcurrentMap<String, Authority> authorityMap = Authority.RESOLVED_AUTHORITY;
        String authorityUrlStr = this.mAuthorityUrl.toString();
        return authorityMap.containsKey(authorityUrlStr) && authorityMap.get(authorityUrlStr) instanceof AdfsAuthority && ((AdfsAuthority)authorityMap.get(authorityUrlStr)).getADFSValidatedAuthorities().contains(AdfsAuthority.getDomainFromUPN(userPrincipalName));
    }

    @Override
    void addToResolvedAuthorityCache(String userPrincipalName) {
        AdfsAuthority adfsInstance = this;
        String authorityUrlStr = this.mAuthorityUrl.toString();
        if (Authority.RESOLVED_AUTHORITY.containsKey(authorityUrlStr)) {
            adfsInstance = (AdfsAuthority)RESOLVED_AUTHORITY.get(authorityUrlStr);
        }
        adfsInstance.getADFSValidatedAuthorities().add(AdfsAuthority.getDomainFromUPN(userPrincipalName));
        Authority.RESOLVED_AUTHORITY.put(authorityUrlStr, adfsInstance);
    }

    @Override
    String performInstanceDiscovery(RequestContext requestContext, String userPrincipalName) throws MsalClientException, MsalServiceException {
        if (this.mValidateAuthority) {
            URI authorityURI;
            DrsMetadata drsMetadata = this.loadDRSMetadata(requestContext, userPrincipalName);
            WebFingerMetadata webFingerMetadata = this.loadWebFingerMetadata(requestContext, drsMetadata);
            try {
                authorityURI = this.mAuthorityUrl.toURI();
            }
            catch (URISyntaxException e) {
                throw new MsalClientException("unsupported_url", "Authority url cannot be constructed to be URI. ", e);
            }
            if (!AdfsWebFingerValidator.realmIsTrusted(requestContext, authorityURI, webFingerMetadata)) {
                throw new MsalClientException("adfs_authority_validation_failed", "Realm is not trusted, adfs authority validation failed.");
            }
            this.mIsAuthorityValidated = true;
        }
        return this.getDefaultOpenIdConfigurationEndpoint();
    }

    Set<String> getADFSValidatedAuthorities() {
        return this.mADFSValidatedAuthorities;
    }

    private WebFingerMetadata loadWebFingerMetadata(RequestContext requestContext, DrsMetadata drsMetadata) throws MsalClientException, MsalServiceException {
        WebFingerMetadataRequestor webFingerMetadataRequestor = new WebFingerMetadataRequestor(requestContext);
        return webFingerMetadataRequestor.requestMetadata(new WebFingerMetadataRequestParameters(this.mAuthorityUrl, drsMetadata));
    }

    private DrsMetadata loadDRSMetadata(RequestContext requestContext, String userPrincipalName) throws MsalClientException, MsalServiceException {
        DRSMetadataRequestor drsRequestor = new DRSMetadataRequestor(requestContext);
        return drsRequestor.requestMetadata(AdfsAuthority.getDomainFromUPN(userPrincipalName));
    }

    @Nullable
    static String getDomainFromUPN(String upn) {
        String suffix = null;
        if (upn != null) {
            int dIndex = upn.lastIndexOf(UPN_DOMAIN_SUFFIX_DELIM);
            suffix = -1 == dIndex ? null : upn.substring(dIndex + 1);
        }
        return suffix;
    }

    @Override
    String getDefaultOpenIdConfigurationEndpoint() {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https").authority(this.mAuthorityUrl.getAuthority()).appendPath("adfs").appendPath(".well-known").appendPath("openid-configuration");
        return builder.build().toString();
    }
}

