/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.AbstractMetadataRequestor;
import com.microsoft.identity.client.DrsMetadata;
import com.microsoft.identity.client.HttpRequest;
import com.microsoft.identity.client.HttpResponse;
import com.microsoft.identity.client.Link;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalServiceException;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.WebFingerMetadata;
import com.microsoft.identity.client.WebFingerMetadataRequestParameters;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class WebFingerMetadataRequestor
extends AbstractMetadataRequestor<WebFingerMetadata, WebFingerMetadataRequestParameters> {
    private static final String TAG = WebFingerMetadataRequestor.class.getSimpleName();

    WebFingerMetadataRequestor(RequestContext requestContext) {
        super(requestContext);
    }

    @Override
    WebFingerMetadata requestMetadata(WebFingerMetadataRequestParameters webFingerMetadataRequestParameters) throws MsalServiceException, MsalClientException {
        URL domain = webFingerMetadataRequestParameters.getDomain();
        DrsMetadata drsMetadata = webFingerMetadataRequestParameters.getDrsMetadata();
        Logger.verbose(TAG, this.getRequestContext(), "Validating authority for auth endpoint: " + domain.toString());
        try {
            URL webFingerUrl = WebFingerMetadataRequestor.buildWebFingerUrl(domain, drsMetadata);
            HttpResponse webResponse = HttpRequest.sendGet(webFingerUrl, Collections.EMPTY_MAP, this.getRequestContext());
            int statusCode = webResponse.getStatusCode();
            if (200 != statusCode) {
                throw new MsalServiceException("service_not_available", webResponse.getBody(), webResponse.getStatusCode(), null);
            }
            return this.parseMetadata(webResponse);
        }
        catch (IOException e) {
            throw new MsalClientException("io_error", "Received io exception: " + e.getMessage(), e);
        }
    }

    @Override
    WebFingerMetadata parseMetadata(HttpResponse response) throws MsalClientException {
        WebFingerMetadata webFingerMetadata = new WebFingerMetadata();
        String responseBody = response.getBody();
        try {
            JSONObject responseJson = new JSONObject(responseBody);
            webFingerMetadata.setSubject(responseJson.getString("subject"));
            JSONArray jsonLinkArr = responseJson.getJSONArray("links");
            for (int ii = 0; ii < jsonLinkArr.length(); ++ii) {
                JSONObject jsonLink = jsonLinkArr.getJSONObject(ii);
                Link linkElement = new Link();
                linkElement.setRel(jsonLink.getString("rel"));
                linkElement.setHref(jsonLink.getString("href"));
                webFingerMetadata.getLinks().add(linkElement);
            }
        }
        catch (JSONException e) {
            throw new MsalClientException("json_parse_failure");
        }
        return webFingerMetadata;
    }

    static URL buildWebFingerUrl(URL resource, DrsMetadata drsMetadata) throws MalformedURLException {
        URL passiveAuthEndpoint = new URL(drsMetadata.getIdentityProviderService().getPassiveAuthEndpoint());
        StringBuilder webFingerUrlBuilder = new StringBuilder("https://").append(passiveAuthEndpoint.getHost()).append("/.well-known/webfinger?resource=").append(resource.toString());
        String webFingerUrl = webFingerUrlBuilder.toString();
        return new URL(webFingerUrl);
    }
}

