/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.os.Build;
import android.util.Log;
import com.microsoft.identity.client.ILoggerCallback;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.RequestContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public final class Logger {
    private static final Logger INSTANCE = new Logger();
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private LogLevel mLogLevel = LogLevel.VERBOSE;
    private AtomicReference<ILoggerCallback> mExternalLogger = new AtomicReference<Object>(null);
    private boolean mLogcatLogEnabled = true;
    private boolean mEnablePII = false;

    public static Logger getInstance() {
        return INSTANCE;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.mLogLevel = logLevel;
    }

    public void setExternalLogger(ILoggerCallback externalLogger) {
        if (externalLogger == null) {
            return;
        }
        if (this.mExternalLogger.get() != null) {
            throw new IllegalStateException("External logger is already set, cannot be set again.");
        }
        this.mExternalLogger.set(externalLogger);
    }

    public void setEnableLogcatLog(boolean enableLogcatLog) {
        this.mLogcatLogEnabled = enableLogcatLog;
    }

    public void setEnablePII(boolean enablePII) {
        this.mEnablePII = enablePII;
    }

    static void error(String tag, RequestContext requestContext, String errorMessage, Throwable exception) {
        Logger.getInstance().log(tag, LogLevel.ERROR, requestContext, errorMessage, exception, false);
    }

    static void errorPII(String tag, RequestContext requestContext, String errorMessage, Throwable exception) {
        Logger.getInstance().log(tag, LogLevel.ERROR, requestContext, errorMessage, exception, true);
    }

    static void warning(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().log(tag, LogLevel.WARNING, requestContext, message, null, false);
    }

    static void warningPII(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().log(tag, LogLevel.WARNING, requestContext, message, null, true);
    }

    static void info(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().log(tag, LogLevel.INFO, requestContext, message, null, false);
    }

    static void infoPII(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().log(tag, LogLevel.INFO, requestContext, message, null, true);
    }

    static void verbose(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().log(tag, LogLevel.VERBOSE, requestContext, message, null, false);
    }

    static void verbosePII(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().log(tag, LogLevel.VERBOSE, requestContext, message, null, true);
    }

    private void log(String tag, LogLevel logLevel, RequestContext requestContext, String message, Throwable throwable, boolean containsPII) {
        if (logLevel.compareTo(this.mLogLevel) > 0) {
            return;
        }
        if (!this.mEnablePII && containsPII) {
            return;
        }
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(this.formatMessage(requestContext, message));
        if (throwable != null) {
            logMessage.append(' ').append(Log.getStackTraceString((Throwable)throwable));
        }
        if (this.mLogcatLogEnabled) {
            this.sendLogcatLogs(tag, logLevel, logMessage.toString());
        }
        if (this.mExternalLogger.get() != null) {
            this.mExternalLogger.get().log(tag, logLevel, logMessage.toString(), containsPII);
        }
    }

    private void sendLogcatLogs(String tag, LogLevel logLevel, String message) {
        switch (logLevel) {
            case ERROR: {
                Log.e((String)tag, (String)message);
                break;
            }
            case WARNING: {
                Log.w((String)tag, (String)message);
                break;
            }
            case INFO: {
                Log.i((String)tag, (String)message);
                break;
            }
            case VERBOSE: {
                Log.v((String)tag, (String)message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown loglevel");
            }
        }
    }

    private String formatMessage(RequestContext requestContext, String message) {
        String logMessage = MsalUtils.isEmpty(message) ? "N/A" : message;
        return "MSAL " + PublicClientApplication.getSdkVersion() + " Android " + Build.VERSION.SDK_INT + " [" + Logger.getUTCDateTimeAsString() + this.appendCorrelationId(requestContext) + this.appendComponent(requestContext) + logMessage;
    }

    private String appendCorrelationId(RequestContext requestContext) {
        String formatMessage = "";
        if (requestContext != null && requestContext.getCorrelationId() != null) {
            formatMessage = formatMessage + " - " + requestContext.getCorrelationId().toString();
        }
        return formatMessage + "] ";
    }

    private String appendComponent(RequestContext requestContext) {
        if (requestContext != null && !MsalUtils.isEmpty(requestContext.getComponent())) {
            return "(" + requestContext.getComponent() + ") ";
        }
        return "";
    }

    private static String getUTCDateTimeAsString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date());
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        VERBOSE;

    }
}

