/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.util.Base64;
import com.microsoft.identity.client.AuthenticationActivity;
import com.microsoft.identity.client.AuthenticationRequestParameters;
import com.microsoft.identity.client.AuthenticationResult;
import com.microsoft.identity.client.AuthorizationResult;
import com.microsoft.identity.client.BaseRequest;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalServiceException;
import com.microsoft.identity.client.MsalUiRequiredException;
import com.microsoft.identity.client.MsalUserCancelException;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.Oauth2Client;
import com.microsoft.identity.client.PlatformIdHelper;
import com.microsoft.identity.client.UiBehavior;
import com.microsoft.identity.client.User;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

final class InteractiveRequest
extends BaseRequest {
    private static final String TAG = InteractiveRequest.class.getSimpleName();
    private final Set<String> mExtraScopesToConsent = new HashSet<String>();
    static final int BROWSER_FLOW = 1001;
    private static AuthorizationResult sAuthorizationResult;
    private static CountDownLatch sResultLock;
    private final ActivityWrapper mActivityWrapper;
    private PKCEChallengeFactory.PKCEChallenge mPKCEChallenge;

    InteractiveRequest(Activity activity, AuthenticationRequestParameters authRequestParameters, String[] extraScopesToConsent) {
        super(activity.getApplicationContext(), authRequestParameters);
        this.mActivityWrapper = new ActivityWrapper(activity);
        if (MsalUtils.isEmpty(authRequestParameters.getRedirectUri())) {
            throw new IllegalArgumentException("redirect is empty");
        }
        if (extraScopesToConsent != null && extraScopesToConsent.length > 0) {
            HashSet<String> extraScopesToConsentSet = new HashSet<String>(Arrays.asList(extraScopesToConsent));
            this.validateInputScopes(extraScopesToConsentSet);
            this.mExtraScopesToConsent.addAll(extraScopesToConsentSet);
        }
    }

    @Override
    synchronized void preTokenRequest() throws MsalUserCancelException, MsalClientException, MsalServiceException, MsalUiRequiredException {
        String authorizeUri;
        super.preTokenRequest();
        try {
            Logger.info(TAG, this.mAuthRequestParameters.getRequestContext(), "Prepare authorize request uri for interactive flow.");
            authorizeUri = this.appendQueryStringToAuthorizeEndpoint();
        }
        catch (UnsupportedEncodingException e) {
            throw new MsalClientException("unsupported_encoding", e.getMessage(), e);
        }
        Intent intentToLaunch = new Intent(this.mContext, AuthenticationActivity.class);
        intentToLaunch.putExtra("com.microsoft.identity.request.url.key", authorizeUri);
        intentToLaunch.putExtra("com.microsoft.identity.request.id", this.mRequestId);
        intentToLaunch.putExtra("com.microsoft.identity.telemetry.request.id", this.mAuthRequestParameters.getRequestContext().getTelemetryRequestId().toString());
        if (!this.resolveIntent(intentToLaunch)) {
            throw new MsalClientException("unresolvable_intent", "The intent is not resolvable");
        }
        this.throwIfNetworkNotAvailable();
        this.mActivityWrapper.startActivityForResult(intentToLaunch, 1001);
        try {
            if (sResultLock.getCount() == 0L) {
                sResultLock = new CountDownLatch(1);
            }
            sResultLock.await();
        }
        catch (InterruptedException e) {
            Logger.error(TAG, this.mAuthRequestParameters.getRequestContext(), "Fail to lock the thread for waiting for authorize request to return.", e);
        }
        this.processAuthorizationResult(sAuthorizationResult);
    }

    @Override
    void setAdditionalOauthParameters(Oauth2Client oauth2Client) {
        oauth2Client.addBodyParameter("grant_type", "authorization_code");
        oauth2Client.addBodyParameter("code", sAuthorizationResult.getAuthCode());
        oauth2Client.addBodyParameter("redirect_uri", this.mAuthRequestParameters.getRedirectUri());
        oauth2Client.addBodyParameter("code_verifier", this.mPKCEChallenge.mCodeVerifier);
    }

    @Override
    AuthenticationResult postTokenRequest() throws MsalUiRequiredException, MsalServiceException, MsalClientException {
        if (!this.isAccessTokenReturned()) {
            this.throwExceptionFromTokenResponse(this.mTokenResponse);
        }
        return super.postTokenRequest();
    }

    static synchronized void onActivityResult(int requestCode, int resultCode, Intent data) {
        Logger.info(TAG, null, "Received request code is: " + requestCode + "; result code is: " + resultCode);
        try {
            if (requestCode != 1001) {
                throw new IllegalStateException("Unknown request code");
            }
            sAuthorizationResult = AuthorizationResult.create(resultCode, data);
        }
        finally {
            sResultLock.countDown();
        }
    }

    String appendQueryStringToAuthorizeEndpoint() throws UnsupportedEncodingException, MsalClientException {
        String authorizationUrl = MsalUtils.appendQueryParameterToUrl(this.mAuthRequestParameters.getAuthority().getAuthorizeEndpoint(), this.createAuthorizationRequestParameters());
        Logger.infoPII(TAG, this.mAuthRequestParameters.getRequestContext(), "Request uri to authorize endpoint is: " + authorizationUrl);
        return authorizationUrl;
    }

    private boolean resolveIntent(Intent intent) {
        ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent, 0);
        return resolveInfo != null;
    }

    private Map<String, String> createAuthorizationRequestParameters() throws UnsupportedEncodingException, MsalClientException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        HashSet<String> scopes = new HashSet<String>(this.mAuthRequestParameters.getScope());
        scopes.addAll(this.mExtraScopesToConsent);
        Set<String> requestedScopes = this.getDecoratedScope(scopes);
        requestParameters.put("scope", MsalUtils.convertSetToString(requestedScopes, " "));
        requestParameters.put("client_id", this.mAuthRequestParameters.getClientId());
        requestParameters.put("redirect_uri", this.mAuthRequestParameters.getRedirectUri());
        requestParameters.put("response_type", "code");
        requestParameters.put("client-request-id", this.mAuthRequestParameters.getRequestContext().getCorrelationId().toString());
        requestParameters.putAll(PlatformIdHelper.getPlatformIdParameters());
        this.addExtraQueryParameter("login_hint", this.mAuthRequestParameters.getLoginHint(), requestParameters);
        this.addUiBehaviorToRequestParameters(requestParameters);
        requestParameters.put("state", this.encodeProtocolState());
        this.addPKCEChallengeToRequestParameters(requestParameters);
        this.addSessionContinuationQps(requestParameters);
        if (!MsalUtils.isEmpty(this.mAuthRequestParameters.getExtraQueryParam())) {
            this.appendExtraQueryParameters(this.mAuthRequestParameters.getExtraQueryParam(), requestParameters);
        }
        if (!MsalUtils.isEmpty(this.mAuthRequestParameters.getSliceParameters())) {
            this.appendExtraQueryParameters(this.mAuthRequestParameters.getSliceParameters(), requestParameters);
        }
        return requestParameters;
    }

    private void appendExtraQueryParameters(String queryParams, Map<String, String> requestParams) throws MsalClientException {
        Map<String, String> extraQps = MsalUtils.decodeUrlToMap(queryParams, "&");
        Set<Map.Entry<String, String>> extraQpEntries = extraQps.entrySet();
        for (Map.Entry<String, String> extraQpEntry : extraQpEntries) {
            if (requestParams.containsKey(extraQpEntry.getKey())) {
                throw new MsalClientException("duplicate_query_parameter", "Extra query parameter " + extraQpEntry.getKey() + " is already sent by the SDK. ");
            }
            requestParams.put(extraQpEntry.getKey(), extraQpEntry.getValue());
        }
    }

    private void addSessionContinuationQps(Map<String, String> requestParams) {
        User user = this.mAuthRequestParameters.getUser();
        if (user != null) {
            this.addExtraQueryParameter("login_req", user.getUid(), requestParams);
            this.addExtraQueryParameter("domain_req", user.getUtid(), requestParams);
            this.addExtraQueryParameter("login_hint", user.getDisplayableId(), requestParams);
        }
    }

    private void addPKCEChallengeToRequestParameters(Map<String, String> requestParameters) throws MsalClientException {
        this.mPKCEChallenge = PKCEChallengeFactory.newPKCEChallenge();
        requestParameters.put("code_challenge", this.mPKCEChallenge.mCodeChallenge);
        requestParameters.put("code_challenge_method", PKCEChallengeFactory.PKCEChallenge.ChallengeMethod.S256.name());
    }

    private void addUiBehaviorToRequestParameters(Map<String, String> requestParameters) {
        UiBehavior uiBehavior = this.mAuthRequestParameters.getUiBehavior();
        if (uiBehavior == UiBehavior.FORCE_LOGIN) {
            requestParameters.put("prompt", "login");
        } else if (uiBehavior == UiBehavior.SELECT_ACCOUNT) {
            requestParameters.put("prompt", "select_account");
        } else if (uiBehavior == UiBehavior.CONSENT) {
            requestParameters.put("prompt", "consent");
        }
    }

    private String encodeProtocolState() throws UnsupportedEncodingException {
        String state = String.format("a=%s&r=%s", MsalUtils.urlFormEncode(this.mAuthRequestParameters.getAuthority().getAuthority()), MsalUtils.urlFormEncode(MsalUtils.convertSetToString(this.mAuthRequestParameters.getScope(), " ")));
        return Base64.encodeToString((byte[])state.getBytes("UTF-8"), (int)9);
    }

    private void processAuthorizationResult(AuthorizationResult authorizationResult) throws MsalUserCancelException, MsalServiceException, MsalClientException {
        if (authorizationResult == null) {
            Logger.error(TAG, this.mAuthRequestParameters.getRequestContext(), "Authorization result is null", null);
            throw new MsalClientException("unknown_error", "Receives empty result for authorize request");
        }
        AuthorizationResult.AuthorizationStatus status = authorizationResult.getAuthorizationStatus();
        Logger.info(TAG, this.mAuthRequestParameters.getRequestContext(), "Authorize request status is: " + status.toString());
        switch (status) {
            case USER_CANCEL: {
                throw new MsalUserCancelException();
            }
            case FAIL: {
                throw new MsalServiceException(authorizationResult.getError(), authorizationResult.getError() + ";" + authorizationResult.getErrorDescription(), MsalServiceException.DEFAULT_STATUS_CODE, null);
            }
            case SUCCESS: {
                this.verifyStateInResponse(authorizationResult.getState());
                return;
            }
        }
        throw new IllegalStateException("Unknown status code");
    }

    private void verifyStateInResponse(String stateInResponse) throws MsalClientException {
        String decodeState = this.decodeState(stateInResponse);
        Map<String, String> stateMap = MsalUtils.decodeUrlToMap(decodeState, "&");
        if (stateMap.size() != 2 || !this.mAuthRequestParameters.getAuthority().getAuthority().equals(stateMap.get("a"))) {
            throw new MsalClientException("state_mismatch", "Returned state from authorize endpoint is not the same as the one sent");
        }
        Set<String> scopesInState = MsalUtils.getScopesAsSet(stateMap.get("r"));
        Set<String> scopesInRequest = this.mAuthRequestParameters.getScope();
        if (scopesInState.size() != scopesInRequest.size() && !scopesInState.containsAll(scopesInRequest)) {
            throw new MsalClientException("state_mismatch", "Returned state from authorize endpoint is not the same as the one sent");
        }
    }

    private String decodeState(String encodedState) {
        if (MsalUtils.isEmpty(encodedState)) {
            return null;
        }
        byte[] stateBytes = Base64.decode((String)encodedState, (int)9);
        return new String(stateBytes);
    }

    private void addExtraQueryParameter(String key, String value, Map<String, String> requestParams) {
        if (!MsalUtils.isEmpty(key) && !MsalUtils.isEmpty(value)) {
            requestParams.put(key, value);
        }
    }

    static {
        sResultLock = new CountDownLatch(1);
    }

    static class ActivityWrapper {
        private WeakReference<Activity> mReferencedActivity;

        ActivityWrapper(Activity activity) {
            this.mReferencedActivity = new WeakReference<Activity>(activity);
        }

        void startActivityForResult(Intent intent, int requestCode) throws MsalClientException {
            if (this.mReferencedActivity.get() == null) {
                throw new MsalClientException("unresolvable_intent", "The referenced object is already being garbage collected.");
            }
            ((Activity)this.mReferencedActivity.get()).startActivityForResult(intent, requestCode);
        }
    }

    private static class PKCEChallengeFactory {
        private static final int CODE_VERIFIER_BYTE_SIZE = 32;
        private static final int ENCODE_MASK = 11;
        private static final String DIGEST_ALGORITHM = "SHA-256";
        private static final String ISO_8859_1 = "ISO_8859_1";

        private PKCEChallengeFactory() {
        }

        static PKCEChallenge newPKCEChallenge() throws MsalClientException {
            String codeVerifier = PKCEChallengeFactory.generateCodeVerifier();
            String codeChallenge = PKCEChallengeFactory.generateCodeVerifierChallenge(codeVerifier);
            return new PKCEChallenge(codeVerifier, codeChallenge);
        }

        private static String generateCodeVerifier() {
            byte[] verifierBytes = new byte[32];
            new SecureRandom().nextBytes(verifierBytes);
            return Base64.encodeToString((byte[])verifierBytes, (int)11);
        }

        private static String generateCodeVerifierChallenge(String verifier) throws MsalClientException {
            try {
                MessageDigest digester = MessageDigest.getInstance(DIGEST_ALGORITHM);
                digester.update(verifier.getBytes(ISO_8859_1));
                byte[] digestBytes = digester.digest();
                return Base64.encodeToString((byte[])digestBytes, (int)11);
            }
            catch (NoSuchAlgorithmException e) {
                throw new MsalClientException("no_such_algorithm", "Failed to generate the code verifier challenge", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new MsalClientException("unsupported_encoding", "Every implementation of the Java platform is required to support ISO-8859-1.Consult the release documentation for your implementation.", e);
            }
        }

        static class PKCEChallenge {
            private final String mCodeVerifier;
            private final String mCodeChallenge;

            PKCEChallenge(String codeVerifier, String codeChallenge) {
                this.mCodeVerifier = codeVerifier;
                this.mCodeChallenge = codeChallenge;
            }

            static enum ChallengeMethod {
                S256;

            }
        }
    }
}

