/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import java.util.Queue;

final class HttpUrlConnectionFactory {
    private static Queue<HttpURLConnection> sMockedConnectionQueue = new LinkedList<HttpURLConnection>();

    private HttpUrlConnectionFactory() {
    }

    static void addMockedConnection(HttpURLConnection mockedConnection) {
        sMockedConnectionQueue.add(mockedConnection);
    }

    static void clearMockedConnectionQueue() {
        sMockedConnectionQueue.clear();
    }

    static int getMockedConnectionCountInQueue() {
        return sMockedConnectionQueue.size();
    }

    static HttpURLConnection createHttpURLConnection(URL url) throws IOException {
        if (!sMockedConnectionQueue.isEmpty()) {
            return sMockedConnectionQueue.poll();
        }
        return (HttpURLConnection)url.openConnection();
    }
}

