/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.HttpEvent;
import com.microsoft.identity.client.HttpResponse;
import com.microsoft.identity.client.HttpUrlConnectionFactory;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalServiceException;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.Telemetry;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class HttpRequest {
    private static final String TAG = HttpRequest.class.getSimpleName();
    private static final String HOST = "Host";
    private static final int RETRY_TIME_WAITING_PERIOD_MSEC = 1000;
    private static final int STREAM_BUFFER_SIZE = 1024;
    static final String REQUEST_METHOD_GET = "GET";
    static final String REQUEST_METHOD_POST = "POST";
    static final int CONNECT_TIME_OUT_MSEC = 30000;
    static final int READ_TIME_OUT_MSEC = 30000;
    private final URL mRequestUrl;
    private final byte[] mRequestContent;
    private final String mRequestContentType;
    private final String mRequestMethod;
    private final Map<String, String> mRequestHeaders = new HashMap<String, String>();
    private final RequestContext mRequestContext;

    private HttpRequest(URL requestUrl, Map<String, String> requestHeaders, String requestMethod, RequestContext requestContext) {
        this(requestUrl, requestHeaders, requestMethod, null, null, requestContext);
    }

    private HttpRequest(URL requestUrl, Map<String, String> requestHeaders, String requestMethod, byte[] requestContent, String requestContentType, RequestContext requestContext) {
        this.mRequestUrl = requestUrl;
        this.mRequestHeaders.put(HOST, requestUrl.getAuthority());
        this.mRequestHeaders.putAll(requestHeaders);
        this.mRequestMethod = requestMethod;
        this.mRequestContent = requestContent;
        this.mRequestContentType = requestContentType;
        this.mRequestContext = requestContext;
    }

    public static HttpResponse sendPost(URL requestUrl, Map<String, String> requestHeaders, byte[] requestContent, String requestContentType, RequestContext requestContext) throws IOException, MsalServiceException {
        HttpRequest httpRequest = new HttpRequest(requestUrl, requestHeaders, REQUEST_METHOD_POST, requestContent, requestContentType, requestContext);
        Logger.verbose(TAG, requestContext, "Sending Http Post request.");
        return httpRequest.send();
    }

    public static HttpResponse sendGet(URL requestUrl, Map<String, String> requestHeaders, RequestContext requestContext) throws IOException, MsalServiceException {
        HttpRequest httpRequest = new HttpRequest(requestUrl, requestHeaders, REQUEST_METHOD_GET, requestContext);
        Logger.verbose(TAG, requestContext, "Sending Http Get request.");
        return httpRequest.send();
    }

    private HttpResponse send() throws IOException, MsalServiceException {
        HttpResponse response;
        try {
            response = this.sendWithRetry();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new MsalServiceException("request_timeout", "Retry failed again with SocketTimeout", socketTimeoutException);
        }
        if (response != null && HttpRequest.isRetryableError(response.getStatusCode())) {
            throw new MsalServiceException("service_not_available", "Retry failed again with 500/503/504", response.getStatusCode(), null);
        }
        return response;
    }

    private HttpResponse sendWithRetry() throws IOException {
        HttpResponse httpResponse;
        try {
            httpResponse = this.executeHttpSend();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Logger.verbose(TAG, this.mRequestContext, "Request timeout with SocketTimeoutException, will retry one more time.");
            this.waitBeforeRetry();
            return this.executeHttpSend();
        }
        if (HttpRequest.isRetryableError(httpResponse.getStatusCode())) {
            Logger.verbose(TAG, this.mRequestContext, "Received retryable status code 500/503/504, will retry one more time.");
            this.waitBeforeRetry();
            return this.executeHttpSend();
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeHttpSend() throws IOException {
        HttpResponse response;
        HttpEvent.Builder httpEventBuilder = new HttpEvent.Builder().setHttpPath(this.mRequestUrl).setHttpMethod(this.mRequestMethod).setQueryParameters(this.mRequestUrl.getQuery());
        Telemetry.getInstance().startEvent(this.mRequestContext.getTelemetryRequestId(), httpEventBuilder.getEventName());
        HttpURLConnection urlConnection = this.setupConnection();
        urlConnection.setRequestMethod(this.mRequestMethod);
        HttpRequest.setRequestBody(urlConnection, this.mRequestContent, this.mRequestContentType);
        InputStream responseStream = null;
        try {
            try {
                responseStream = urlConnection.getInputStream();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw socketTimeoutException;
            }
            catch (IOException ioException) {
                responseStream = urlConnection.getErrorStream();
            }
            int statusCode = urlConnection.getResponseCode();
            httpEventBuilder.setStatusCode(statusCode);
            String responseBody = responseStream == null ? "" : HttpRequest.convertStreamToString(responseStream);
            Logger.verbose(TAG, this.mRequestContext, "Returned status code is: " + statusCode);
            response = new HttpResponse(statusCode, responseBody, urlConnection.getHeaderFields());
        }
        finally {
            HttpRequest.safeCloseStream(responseStream);
        }
        Telemetry.getInstance().stopEvent(this.mRequestContext.getTelemetryRequestId(), httpEventBuilder);
        return response;
    }

    private HttpURLConnection setupConnection() throws IOException {
        HttpURLConnection urlConnection = HttpUrlConnectionFactory.createHttpURLConnection(this.mRequestUrl);
        urlConnection.setRequestProperty("Connection", "close");
        Set<Map.Entry<String, String>> headerEntries = this.mRequestHeaders.entrySet();
        for (Map.Entry<String, String> entry : headerEntries) {
            urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        urlConnection.setConnectTimeout(30000);
        urlConnection.setReadTimeout(30000);
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.setUseCaches(false);
        urlConnection.setDoInput(true);
        return urlConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRequestBody(HttpURLConnection connection, byte[] contentRequest, String requestContentType) throws IOException {
        if (contentRequest == null) {
            return;
        }
        connection.setDoOutput(true);
        if (!MsalUtils.isEmpty(requestContentType)) {
            connection.setRequestProperty("Content-Type", requestContentType);
        }
        connection.setRequestProperty("Content-Length", String.valueOf(contentRequest.length));
        connection.setFixedLengthStreamingMode(contentRequest.length);
        OutputStream out = null;
        try {
            out = connection.getOutputStream();
            out.write(contentRequest);
        }
        finally {
            HttpRequest.safeCloseStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        try {
            int charsRead;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            char[] buffer = new char[1024];
            StringBuilder stringBuilder = new StringBuilder();
            while ((charsRead = reader.read(buffer)) > -1) {
                stringBuilder.append(buffer, 0, charsRead);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            HttpRequest.safeCloseStream(inputStream);
        }
    }

    private static void safeCloseStream(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            Logger.error(TAG, null, "Encounter IO exception when trying to close the stream", e);
        }
    }

    private static boolean isRetryableError(int statusCode) {
        return statusCode == 500 || statusCode == 504 || statusCode == 503;
    }

    private void waitBeforeRetry() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interrupted) {
            Logger.info(TAG, this.mRequestContext, "Fail the have the thread waiting for 1 second before doing the retry");
        }
    }
}

