/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import com.microsoft.identity.client.AccessTokenCacheItem;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.AuthenticationRequestParameters;
import com.microsoft.identity.client.AuthenticationResult;
import com.microsoft.identity.client.Authority;
import com.microsoft.identity.client.ClientInfo;
import com.microsoft.identity.client.IdToken;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalException;
import com.microsoft.identity.client.MsalServiceException;
import com.microsoft.identity.client.MsalUiRequiredException;
import com.microsoft.identity.client.MsalUserCancelException;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.Oauth2Client;
import com.microsoft.identity.client.OauthConstants;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.TokenCache;
import com.microsoft.identity.client.TokenResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

abstract class BaseRequest {
    private static final String TAG = BaseRequest.class.getSimpleName();
    private static final ExecutorService THREAD_EXECUTOR = Executors.newSingleThreadExecutor();
    private Handler mHandler;
    protected final RequestContext mRequestContext;
    protected final AuthenticationRequestParameters mAuthRequestParameters;
    protected final Context mContext;
    protected int mRequestId;
    protected TokenResponse mTokenResponse;

    void preTokenRequest() throws MsalUiRequiredException, MsalUserCancelException, MsalServiceException, MsalClientException {
        this.mAuthRequestParameters.getAuthority().resolveEndpoints(this.mAuthRequestParameters.getRequestContext(), this.mAuthRequestParameters.getLoginHint());
    }

    abstract void setAdditionalOauthParameters(Oauth2Client var1);

    BaseRequest(Context appContext, AuthenticationRequestParameters authenticationRequestParameters) {
        this.mContext = appContext;
        this.mAuthRequestParameters = authenticationRequestParameters;
        this.mRequestContext = authenticationRequestParameters.getRequestContext();
        if (authenticationRequestParameters.getScope() == null || authenticationRequestParameters.getScope().isEmpty()) {
            throw new IllegalArgumentException("scope is empty or null");
        }
        this.validateInputScopes(authenticationRequestParameters.getScope());
    }

    void getToken(final AuthenticationCallback callback) {
        this.mRequestId = callback.hashCode();
        THREAD_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseRequest.this.preTokenRequest();
                    BaseRequest.this.performTokenRequest();
                    AuthenticationResult result = BaseRequest.this.postTokenRequest();
                    Logger.info(TAG, BaseRequest.this.mAuthRequestParameters.getRequestContext(), "Token request succeeds.");
                    BaseRequest.this.callbackOnSuccess(callback, result);
                }
                catch (MsalUserCancelException userCancelException) {
                    Logger.error(TAG, BaseRequest.this.mAuthRequestParameters.getRequestContext(), "User cancelled the flow.", userCancelException);
                    BaseRequest.this.callbackOnCancel(callback);
                }
                catch (MsalException msalException) {
                    Logger.error(TAG, BaseRequest.this.mAuthRequestParameters.getRequestContext(), "Error occurred during authentication.", msalException);
                    BaseRequest.this.callbackOnError(callback, msalException);
                }
            }
        });
    }

    Set<String> getDecoratedScope(Set<String> inputScopes) {
        HashSet<String> scopes = new HashSet<String>(inputScopes);
        Set<String> reservedScopes = this.getReservedScopesAsSet();
        scopes.addAll(reservedScopes);
        scopes.remove(this.mAuthRequestParameters.getClientId());
        return scopes;
    }

    void validateInputScopes(Set<String> inputScopes) {
        HashSet<String> scopes = new HashSet<String>(inputScopes);
        Set<String> reservedScopes = this.getReservedScopesAsSet();
        if (!scopes.retainAll(reservedScopes)) {
            throw new IllegalArgumentException("MSAL always sends the scopes 'openid profile offline_access'. They cannot be suppressed as they are required for the library to function. Do not include any of these in the scopes parameter.");
        }
        if (inputScopes.contains(this.mAuthRequestParameters.getClientId())) {
            throw new IllegalArgumentException("Client id cannot be provided as scope.");
        }
    }

    void performTokenRequest() throws MsalClientException, MsalServiceException {
        TokenResponse tokenResponse;
        this.throwIfNetworkNotAvailable();
        Oauth2Client oauth2Client = new Oauth2Client(this.mRequestContext);
        this.buildRequestParameters(oauth2Client);
        try {
            tokenResponse = oauth2Client.getToken(this.mAuthRequestParameters.getAuthority());
        }
        catch (IOException e) {
            Logger.error(TAG, this.mRequestContext, "Token request failed with error: " + e.getMessage(), e);
            throw new MsalClientException("io_error", "Auth failed with the error " + e.getMessage(), e);
        }
        this.mTokenResponse = tokenResponse;
    }

    AuthenticationResult postTokenRequest() throws MsalUiRequiredException, MsalServiceException, MsalClientException {
        this.checkUserMismatch();
        TokenCache tokenCache = this.mAuthRequestParameters.getTokenCache();
        Authority authority = this.mAuthRequestParameters.getAuthority();
        authority.updateTenantLessAuthority(new IdToken(this.mTokenResponse.getRawIdToken()).getTenantId());
        AccessTokenCacheItem accessTokenCacheItem = tokenCache.saveAccessToken(authority.getAuthority(), this.mAuthRequestParameters.getClientId(), this.mTokenResponse, this.mRequestContext);
        tokenCache.saveRefreshToken(authority.getAuthorityHost(), this.mAuthRequestParameters.getClientId(), this.mTokenResponse, this.mRequestContext);
        return new AuthenticationResult(accessTokenCacheItem);
    }

    boolean isAccessTokenReturned() {
        return !MsalUtils.isEmpty(this.mTokenResponse.getAccessToken()) || !MsalUtils.isEmpty(this.mTokenResponse.getRawIdToken());
    }

    void throwIfNetworkNotAvailable() throws MsalClientException {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            Logger.error(TAG, this.mRequestContext, "No active network is available on the device.", null);
            throw new MsalClientException("device_network_not_available", "Device network connection is not available.");
        }
    }

    void throwExceptionFromTokenResponse(TokenResponse tokenResponse) throws MsalUiRequiredException, MsalServiceException {
        if (MsalUtils.isEmpty(tokenResponse.getError())) {
            throw new MsalServiceException("unknown_error", "Request failed, but no error returned back from service.", tokenResponse.getHttpStatusCode(), null);
        }
        if ("invalid_grant".equals(tokenResponse.getError())) {
            throw new MsalUiRequiredException("invalid_grant", tokenResponse.getErrorDescription(), null);
        }
        throw new MsalServiceException(tokenResponse.getError(), tokenResponse.getErrorDescription(), tokenResponse.getHttpStatusCode(), null);
    }

    private synchronized Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.mContext.getMainLooper());
        }
        return this.mHandler;
    }

    private void buildRequestParameters(Oauth2Client oauth2Client) {
        oauth2Client.addHeader("client-request-id", this.mRequestContext.getCorrelationId().toString());
        oauth2Client.addBodyParameter("client_id", this.mAuthRequestParameters.getClientId());
        String scope = MsalUtils.convertSetToString(this.getDecoratedScope(this.mAuthRequestParameters.getScope()), " ");
        oauth2Client.addBodyParameter("scope", scope);
        oauth2Client.addBodyParameter("client_info", "1");
        this.setAdditionalOauthParameters(oauth2Client);
        if (!MsalUtils.isEmpty(this.mAuthRequestParameters.getSliceParameters())) {
            Map<String, String> sliceParameters = MsalUtils.decodeUrlToMap(this.mAuthRequestParameters.getSliceParameters(), "&");
            Set<Map.Entry<String, String>> sliceParameterEntries = sliceParameters.entrySet();
            for (Map.Entry<String, String> sliceParameterEntry : sliceParameterEntries) {
                oauth2Client.addQueryParameter(sliceParameterEntry.getKey(), sliceParameterEntry.getValue());
            }
        }
    }

    private Set<String> getReservedScopesAsSet() {
        return new HashSet<String>(Arrays.asList(OauthConstants.Oauth2Value.RESERVED_SCOPES));
    }

    private void checkUserMismatch() throws MsalClientException {
        ClientInfo returnedClientInfo = new ClientInfo(this.mTokenResponse.getRawClientInfo());
        String uniqueUserIdentifer = MsalUtils.getUniqueUserIdentifier(returnedClientInfo.getUniqueIdentifier(), returnedClientInfo.getUniqueTenantIdentifier());
        if (this.mAuthRequestParameters.getUser() != null && !this.mAuthRequestParameters.getUser().getUserIdentifier().equals(uniqueUserIdentifer)) {
            Logger.errorPII(TAG, this.mAuthRequestParameters.getRequestContext(), "User unique identifier provided in the request is: " + this.mAuthRequestParameters.getUser().getUserIdentifier() + ". The user unique identifier returned from token endpoint is: " + uniqueUserIdentifer, null);
            throw new MsalClientException("user_mismatch", "User unique identifier provided in the request doesn't match the one returned in the token response");
        }
    }

    private void callbackOnSuccess(final AuthenticationCallback callback, final AuthenticationResult result) {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                callback.onSuccess(result);
            }
        });
    }

    private void callbackOnCancel(final AuthenticationCallback callback) {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                callback.onCancel();
            }
        });
    }

    private void callbackOnError(final AuthenticationCallback callback, final MsalException msalException) {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                callback.onError(msalException);
            }
        });
    }
}

