/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.Authority;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.TokenCache;
import com.microsoft.identity.client.UiBehavior;
import com.microsoft.identity.client.User;
import java.util.HashSet;
import java.util.Set;

final class AuthenticationRequestParameters {
    private static final String TAG = AuthenticationRequestParameters.class.getSimpleName();
    private final TokenCache mTokenCache;
    private final Set<String> mScope = new HashSet<String>();
    private final String mClientId;
    private final RequestContext mRequestContext;
    private Authority mAuthority;
    private String mRedirectUri;
    private String mLoginHint;
    private String mExtraQueryParam;
    private String mSliceParameters;
    private UiBehavior mUiBehavior;
    private User mUser;

    private AuthenticationRequestParameters(Authority authority, TokenCache tokenCache, Set<String> scope, String clientId, String sliceParameters, RequestContext requestContext) {
        if (requestContext == null || requestContext.getCorrelationId() == null) {
            throw new IllegalArgumentException("correlationId");
        }
        if (scope == null) {
            throw new IllegalArgumentException("scope");
        }
        if (tokenCache == null) {
            throw new IllegalArgumentException("tokenCache");
        }
        this.mAuthority = authority;
        this.mTokenCache = tokenCache;
        this.mScope.addAll(scope);
        this.mClientId = clientId;
        this.mSliceParameters = sliceParameters;
        this.mRequestContext = requestContext;
    }

    static AuthenticationRequestParameters create(Authority authority, TokenCache tokenCache, Set<String> scope, String clientId, String redirectUri, String loginHint, String extraQueryParam, UiBehavior uiBehavior, User user, String sliceParameters, RequestContext requestContext) {
        AuthenticationRequestParameters requestParameters = new AuthenticationRequestParameters(authority, tokenCache, scope, clientId, sliceParameters, requestContext);
        requestParameters.setRedirectUri(redirectUri);
        requestParameters.setLoginHint(loginHint);
        requestParameters.setExtraQueryParam(extraQueryParam);
        requestParameters.setUIBehavior(uiBehavior);
        requestParameters.setUser(user);
        return requestParameters;
    }

    static AuthenticationRequestParameters create(Authority authority, TokenCache tokenCache, Set<String> scope, String clientId, String sliceParameters, RequestContext requestContext) {
        return new AuthenticationRequestParameters(authority, tokenCache, scope, clientId, sliceParameters, requestContext);
    }

    Authority getAuthority() {
        return this.mAuthority;
    }

    void setAuthority(String authorityString, boolean isAuthorityValidationOn) {
        this.mAuthority = Authority.createAuthority(authorityString, isAuthorityValidationOn);
    }

    TokenCache getTokenCache() {
        return this.mTokenCache;
    }

    Set<String> getScope() {
        return this.mScope;
    }

    String getClientId() {
        return this.mClientId;
    }

    String getRedirectUri() {
        return this.mRedirectUri;
    }

    private void setRedirectUri(String redirectUri) {
        this.mRedirectUri = redirectUri;
    }

    String getLoginHint() {
        return this.mLoginHint;
    }

    private void setLoginHint(String loginHint) {
        this.mLoginHint = loginHint;
    }

    String getExtraQueryParam() {
        return this.mExtraQueryParam;
    }

    private void setExtraQueryParam(String extraQueryParam) {
        this.mExtraQueryParam = extraQueryParam;
    }

    String getSliceParameters() {
        return this.mSliceParameters;
    }

    UiBehavior getUiBehavior() {
        return this.mUiBehavior;
    }

    private void setUIBehavior(UiBehavior uiBehavior) {
        this.mUiBehavior = uiBehavior;
    }

    User getUser() {
        return this.mUser;
    }

    private void setUser(User user) {
        this.mUser = user;
    }

    RequestContext getRequestContext() {
        return this.mRequestContext;
    }
}

