/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.Link;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.WebFingerMetadata;
import java.net.URI;
import java.net.URISyntaxException;

final class AdfsWebFingerValidator {
    private static final String TAG = AdfsWebFingerValidator.class.getSimpleName();
    private static final URI TRUSTED_REALM_REL;

    private AdfsWebFingerValidator() {
    }

    static boolean realmIsTrusted(RequestContext requestContext, URI authority, WebFingerMetadata metadata) {
        if (authority == null) {
            throw new IllegalArgumentException("Authority cannot be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("WebFingerMetadata cannot be null");
        }
        Logger.verbose(TAG, requestContext, "Verifying trust: " + authority.toString() + metadata.toString());
        if (metadata.getLinks() != null) {
            for (Link link : metadata.getLinks()) {
                try {
                    URI href = new URI(link.getHref());
                    URI rel = new URI(link.getRel());
                    if (!href.getScheme().equalsIgnoreCase(authority.getScheme()) || !href.getAuthority().equalsIgnoreCase(authority.getAuthority()) || !rel.equals(TRUSTED_REALM_REL)) continue;
                    return true;
                }
                catch (URISyntaxException e) {
                }
            }
        }
        return false;
    }

    static {
        try {
            TRUSTED_REALM_REL = new URI("http://schemas.microsoft.com/rel/trusted-realm");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

