/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.AccessTokenCacheItem;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.TokenCacheKey;
import com.microsoft.identity.client.User;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

final class AccessTokenCacheKey
extends TokenCacheKey<AccessTokenCacheItem> {
    private final String mAuthority;
    private final TreeSet<String> mScope = new TreeSet();

    private AccessTokenCacheKey(String authority, String clientId, Set<String> scope, String uid, String utid) {
        super(clientId, uid, utid);
        if (MsalUtils.isEmpty(authority)) {
            throw new IllegalArgumentException("authority");
        }
        this.mAuthority = authority.toLowerCase(Locale.US);
        this.mScope.addAll(scope);
    }

    static AccessTokenCacheKey createTokenCacheKey(String authority, String clientId, Set<String> scopes, User user) {
        if (user == null) {
            throw new IllegalArgumentException("null user");
        }
        return new AccessTokenCacheKey(authority, clientId, scopes, user.getUid(), user.getUtid());
    }

    Set<String> getScope() {
        return Collections.unmodifiableSet(this.mScope);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MsalUtils.base64UrlEncodeToString(this.mAuthority));
        stringBuilder.append("$");
        stringBuilder.append(MsalUtils.base64UrlEncodeToString(this.mClientId));
        stringBuilder.append("$");
        stringBuilder.append(MsalUtils.base64UrlEncodeToString(MsalUtils.convertSetToString(this.mScope, " ")));
        stringBuilder.append("$");
        stringBuilder.append(this.mUserIdentifier);
        return stringBuilder.toString();
    }

    @Override
    boolean matches(AccessTokenCacheItem item) {
        return this.mAuthority.equalsIgnoreCase(item.getAuthority()) && this.mClientId.equalsIgnoreCase(item.getClientId()) && this.mUserIdentifier.equals(item.getUserIdentifier());
    }
}

