/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.nativeauth.statemachine.states;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.microsoft.identity.client.AuthenticationResultAdapter;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.internal.CommandParametersAdapter;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.ICommandResult;
import com.microsoft.identity.common.java.controllers.CommandDispatcher;
import com.microsoft.identity.common.java.controllers.CommandResult;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.controllers.results.INativeAuthCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInSubmitPasswordCommandResult;
import com.microsoft.identity.common.java.nativeauth.util.ILoggable;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.nativeauth.internal.commands.SignInSubmitPasswordCommand;
import com.microsoft.identity.common.nativeauth.internal.controllers.NativeAuthMsalController;
import com.microsoft.identity.nativeauth.AuthMethodKt;
import com.microsoft.identity.nativeauth.NativeAuthPublicClientApplication;
import com.microsoft.identity.nativeauth.NativeAuthPublicClientApplicationConfiguration;
import com.microsoft.identity.nativeauth.statemachine.errors.SignInSubmitPasswordError;
import com.microsoft.identity.nativeauth.statemachine.results.SignInResult;
import com.microsoft.identity.nativeauth.statemachine.results.SignInSubmitPasswordResult;
import com.microsoft.identity.nativeauth.statemachine.states.AccountState;
import com.microsoft.identity.nativeauth.statemachine.states.AwaitingMFAState;
import com.microsoft.identity.nativeauth.statemachine.states.BaseState;
import com.microsoft.identity.nativeauth.statemachine.states.Callback;
import com.microsoft.identity.nativeauth.statemachine.states.RegisterStrongAuthState;
import com.microsoft.identity.nativeauth.statemachine.states.State;
import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002 !B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B7\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0015H\u0016R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/SignInPasswordRequiredState;", "Lcom/microsoft/identity/nativeauth/statemachine/states/BaseState;", "Lcom/microsoft/identity/nativeauth/statemachine/states/State;", "Landroid/os/Parcelable;", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "continuationToken", "", "correlationId", "scopes", "", "claimsRequestJson", "config", "Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;)V", "TAG", "getContinuationToken$msal_distRelease", "()Ljava/lang/String;", "getCorrelationId$msal_distRelease", "describeContents", "", "submitPassword", "Lcom/microsoft/identity/nativeauth/statemachine/results/SignInSubmitPasswordResult;", "password", "", "([CLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "callback", "Lcom/microsoft/identity/nativeauth/statemachine/states/SignInPasswordRequiredState$SubmitPasswordCallback;", "writeToParcel", "flags", "CREATOR", "SubmitPasswordCallback", "msal_distRelease"})
public final class SignInPasswordRequiredState
extends BaseState
implements State,
Parcelable {
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);
    @NotNull
    private final String continuationToken;
    @NotNull
    private final String correlationId;
    @Nullable
    private final List<String> scopes;
    @Nullable
    private final String claimsRequestJson;
    @NotNull
    private final NativeAuthPublicClientApplicationConfiguration config;
    @NotNull
    private final String TAG;

    public SignInPasswordRequiredState(@NotNull String continuationToken, @NotNull String correlationId, @Nullable List<String> scopes, @Nullable String claimsRequestJson, @NotNull NativeAuthPublicClientApplicationConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)continuationToken, (String)"continuationToken");
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(continuationToken, correlationId);
        this.continuationToken = continuationToken;
        this.correlationId = correlationId;
        this.scopes = scopes;
        this.claimsRequestJson = claimsRequestJson;
        this.config = config;
        String string = SignInPasswordRequiredState.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SignInPasswordRequiredState::class.java.simpleName");
        this.TAG = string;
    }

    @Override
    @NotNull
    public String getContinuationToken$msal_distRelease() {
        return this.continuationToken;
    }

    @Override
    @NotNull
    public String getCorrelationId$msal_distRelease() {
        return this.correlationId;
    }

    public SignInPasswordRequiredState(@NotNull Parcel parcel) {
        Serializable serializable;
        String string;
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        String string2 = parcel.readString();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = parcel.readString()) == null) {
            string = "UNSET";
        }
        List list = parcel.createStringArrayList();
        String string3 = parcel.readString();
        Parcel $this$serializable$iv = parcel;
        boolean $i$f$serializable = false;
        if (Build.VERSION.SDK_INT >= 33) {
            serializable = (Serializable)$this$serializable$iv.readSerializable(NativeAuthPublicClientApplicationConfiguration.class.getClassLoader(), NativeAuthPublicClientApplicationConfiguration.class);
        } else {
            Serializable serializable2 = $this$serializable$iv.readSerializable();
            if (!(serializable2 instanceof NativeAuthPublicClientApplicationConfiguration)) {
                serializable2 = null;
            }
            serializable = (NativeAuthPublicClientApplicationConfiguration)serializable2;
        }
        Intrinsics.checkNotNull((Object)serializable, (String)"null cannot be cast to non-null type com.microsoft.identity.nativeauth.NativeAuthPublicClientApplicationConfiguration");
        this(string2, string, list, string3, (NativeAuthPublicClientApplicationConfiguration)serializable);
    }

    public final void submitPassword(@NotNull char[] password, @NotNull SubmitPasswordCallback callback) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LogSession.Companion.logMethodCall(this.TAG, this.getCorrelationId$msal_distRelease(), this.TAG + ".submitPassword(password: CharArray, callback: SubmitPasswordCallback)");
        BuildersKt.launch$default((CoroutineScope)NativeAuthPublicClientApplication.Companion.getPcaScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, password, callback, null){
            int label;
            final /* synthetic */ SignInPasswordRequiredState this$0;
            final /* synthetic */ char[] $password;
            final /* synthetic */ SubmitPasswordCallback $callback;
            {
                this.this$0 = $receiver;
                this.$password = $password;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.submitPassword(this.$password, (Continuation<? super SignInSubmitPasswordResult>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            result = (SignInSubmitPasswordResult)v0;
                            this.$callback.onResult(result);
                        }
                        catch (MsalException e) {
                            Logger.error((String)SignInPasswordRequiredState.access$getTAG$p(this.this$0), (String)"Exception thrown in submitPassword", (Throwable)((Throwable)e));
                            this.$callback.onError(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final Object submitPassword(@NotNull char[] password, @NotNull Continuation<? super SignInSubmitPasswordResult> $completion) {
        LogSession.Companion.logMethodCall(this.TAG, this.getCorrelationId$msal_distRelease(), this.TAG + ".submitPassword(password: CharArray)");
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SignInSubmitPasswordResult>, Object>(this, password, null){
            int label;
            final /* synthetic */ SignInPasswordRequiredState this$0;
            final /* synthetic */ char[] $password;
            {
                this.this$0 = $receiver;
                this.$password = $password;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            SignInSubmitPasswordCommandParameters params = CommandParametersAdapter.createSignInSubmitPasswordCommandParameters(SignInPasswordRequiredState.access$getConfig$p(this.this$0), SignInPasswordRequiredState.access$getConfig$p(this.this$0).getOAuth2TokenCache(), this.this$0.getContinuationToken$msal_distRelease(), this.$password, this.this$0.getCorrelationId$msal_distRelease(), SignInPasswordRequiredState.access$getScopes$p(this.this$0), SignInPasswordRequiredState.access$getClaimsRequestJson$p(this.this$0));
                            try {
                                SignInSubmitPasswordResult signInSubmitPasswordResult;
                                String string;
                                INativeAuthCommandResult iNativeAuthCommandResult;
                                Object object2;
                                Intrinsics.checkNotNullExpressionValue((Object)params, (String)"params");
                                SignInSubmitPasswordCommand signInSubmitPasswordCommand = new SignInSubmitPasswordCommand(params, new NativeAuthMsalController(), "214");
                                CommandResult rawCommandResult = (CommandResult)CommandDispatcher.submitSilentReturningFuture((BaseCommand)((BaseCommand)signInSubmitPasswordCommand)).get();
                                Intrinsics.checkNotNullExpressionValue((Object)rawCommandResult, (String)"rawCommandResult");
                                Object $this$checkAndWrapCommandResultType$iv = rawCommandResult;
                                boolean $i$f$checkAndWrapCommandResultType = false;
                                if ($this$checkAndWrapCommandResultType$iv.getStatus() != ICommandResult.ResultStatus.COMPLETED) {
                                    Exception exception$iv = null;
                                    String exceptionMessage$iv = "";
                                    if ($this$checkAndWrapCommandResultType$iv.getResult() instanceof Exception) {
                                        Object object3 = $this$checkAndWrapCommandResultType$iv.getResult();
                                        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                                        exception$iv = (Exception)object3;
                                        exceptionMessage$iv = exception$iv.getMessage();
                                    }
                                    object2 = exceptionMessage$iv;
                                    Exception exception = exception$iv;
                                    String string2 = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"correlationId");
                                    iNativeAuthCommandResult = (INativeAuthCommandResult)((SignInSubmitPasswordCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", (String)object2, null, string2, null, exception, 20, null));
                                } else {
                                    Object result$iv = $this$checkAndWrapCommandResultType$iv.getResult();
                                    boolean bl = false;
                                    if (result$iv instanceof Exception) {
                                        String string3 = "Type casting error: result of " + $this$checkAndWrapCommandResultType$iv + " is of type Exception, even though the command was marked as COMPLETED";
                                        String string4 = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this.correlationId");
                                        iNativeAuthCommandResult = (INativeAuthCommandResult)((SignInSubmitPasswordCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", string3, null, string4, null, null, 52, null));
                                    } else {
                                        INativeAuthCommandResult iNativeAuthCommandResult2;
                                        try {
                                            Object object4 = result$iv;
                                            if (object4 == null) {
                                                throw new NullPointerException("null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.SignInSubmitPasswordCommandResult");
                                            }
                                            iNativeAuthCommandResult2 = (INativeAuthCommandResult)((SignInSubmitPasswordCommandResult)object4);
                                        }
                                        catch (ClassCastException classCastException) {
                                            String string5 = "Type casting error: result of " + $this$checkAndWrapCommandResultType$iv + " is not of type " + Reflection.getOrCreateKotlinClass(SignInSubmitPasswordCommandResult.class) + ", but of type " + Reflection.getOrCreateKotlinClass(result$iv.getClass()) + ", even though the command was marked as COMPLETED";
                                            String string6 = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this.correlationId");
                                            iNativeAuthCommandResult2 = (INativeAuthCommandResult)((SignInSubmitPasswordCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", string5, null, string6, null, null, 52, null));
                                        }
                                        iNativeAuthCommandResult = iNativeAuthCommandResult2;
                                    }
                                }
                                SignInSubmitPasswordCommandResult result = (SignInSubmitPasswordCommandResult)iNativeAuthCommandResult;
                                if (result instanceof SignInCommandResult.InvalidCredentials) {
                                    $this$checkAndWrapCommandResultType$iv = ((SignInCommandResult.InvalidCredentials)result).getErrorDescription();
                                    String string7 = ((SignInCommandResult.InvalidCredentials)result).getError();
                                    string = result.getCorrelationId();
                                    signInSubmitPasswordResult = new SignInSubmitPasswordError("invalid_credentials", string7, (String)$this$checkAndWrapCommandResultType$iv, string, null, null, 48, null);
                                } else if (result instanceof SignInCommandResult.MFARequired) {
                                    signInSubmitPasswordResult = new SignInResult.MFARequired(new AwaitingMFAState(((SignInCommandResult.MFARequired)result).getContinuationToken(), result.getCorrelationId(), SignInPasswordRequiredState.access$getScopes$p(this.this$0), SignInPasswordRequiredState.access$getConfig$p(this.this$0)));
                                } else if (result instanceof SignInCommandResult.StrongAuthMethodRegistrationRequired) {
                                    signInSubmitPasswordResult = new SignInResult.StrongAuthMethodRegistrationRequired(new RegisterStrongAuthState(((SignInCommandResult.StrongAuthMethodRegistrationRequired)result).getContinuationToken(), result.getCorrelationId(), SignInPasswordRequiredState.access$getConfig$p(this.this$0)), AuthMethodKt.toListOfAuthMethods(((SignInCommandResult.StrongAuthMethodRegistrationRequired)result).getAuthMethods()));
                                } else if (result instanceof SignInCommandResult.Complete) {
                                    IAuthenticationResult authenticationResult = AuthenticationResultAdapter.adapt(((SignInCommandResult.Complete)result).getAuthenticationResult());
                                    Intrinsics.checkNotNullExpressionValue((Object)authenticationResult, (String)"authenticationResult");
                                    signInSubmitPasswordResult = new SignInResult.Complete(AccountState.CREATOR.createFromAuthenticationResult(authenticationResult, result.getCorrelationId(), SignInPasswordRequiredState.access$getConfig$p(this.this$0)));
                                } else if (result instanceof INativeAuthCommandResult.Redirect) {
                                    signInSubmitPasswordResult = new SignInSubmitPasswordError("browser_required", ((INativeAuthCommandResult.Redirect)result).getError(), ((INativeAuthCommandResult.Redirect)result).getRedirectReason(), result.getCorrelationId(), ((INativeAuthCommandResult.Redirect)result).getErrorCodes(), null, 32, null);
                                } else if (result instanceof INativeAuthCommandResult.APIError) {
                                    Logger.warnWithObject((String)SignInPasswordRequiredState.access$getTAG$p(this.this$0), (String)result.getCorrelationId(), (String)"Submit password received unexpected result: ", (ILoggable)((ILoggable)result));
                                    String string8 = ((INativeAuthCommandResult.Error)result).getErrorDescription();
                                    String string9 = ((INativeAuthCommandResult.Error)result).getError();
                                    string = ((INativeAuthCommandResult.Error)result).getCorrelationId();
                                    List list = ((INativeAuthCommandResult.Error)result).getErrorCodes();
                                    object2 = ((INativeAuthCommandResult.APIError)result).getException();
                                    signInSubmitPasswordResult = new SignInSubmitPasswordError(null, string9, string8, string, list, (Exception)object2, 1, null);
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                SignInSubmitPasswordResult signInSubmitPasswordResult2 = signInSubmitPasswordResult;
                                return signInSubmitPasswordResult2;
                            }
                            finally {
                                StringUtil.overwriteWithNull((char[])params.password);
                            }
                        }
                        catch (Exception e) {
                            String string = this.this$0.getCorrelationId$msal_distRelease();
                            return new SignInSubmitPasswordError("client_exception", null, "MSAL client exception occurred in submitPassword.", string, null, e, 18, null);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super SignInSubmitPasswordResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        parcel.writeString(this.getContinuationToken$msal_distRelease());
        parcel.writeString(this.getCorrelationId$msal_distRelease());
        parcel.writeStringList(this.scopes);
        parcel.writeSerializable((Serializable)this.config);
        parcel.writeString(this.claimsRequestJson);
    }

    public int describeContents() {
        return 0;
    }

    public static final /* synthetic */ String access$getTAG$p(SignInPasswordRequiredState $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ NativeAuthPublicClientApplicationConfiguration access$getConfig$p(SignInPasswordRequiredState $this) {
        return $this.config;
    }

    public static final /* synthetic */ List access$getScopes$p(SignInPasswordRequiredState $this) {
        return $this.scopes;
    }

    public static final /* synthetic */ String access$getClaimsRequestJson$p(SignInPasswordRequiredState $this) {
        return $this.claimsRequestJson;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/SignInPasswordRequiredState$SubmitPasswordCallback;", "Lcom/microsoft/identity/nativeauth/statemachine/states/Callback;", "Lcom/microsoft/identity/nativeauth/statemachine/results/SignInSubmitPasswordResult;", "msal_distRelease"})
    public static interface SubmitPasswordCallback
    extends Callback<SignInSubmitPasswordResult> {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/SignInPasswordRequiredState$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/microsoft/identity/nativeauth/statemachine/states/SignInPasswordRequiredState;", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/microsoft/identity/nativeauth/statemachine/states/SignInPasswordRequiredState;", "msal_distRelease"})
    public static final class CREATOR
    implements Parcelable.Creator<SignInPasswordRequiredState> {
        private CREATOR() {
        }

        @NotNull
        public SignInPasswordRequiredState createFromParcel(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            return new SignInPasswordRequiredState(parcel);
        }

        @NotNull
        public SignInPasswordRequiredState[] newArray(int size) {
            return new SignInPasswordRequiredState[size];
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

