/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.AuthenticationResultAdapter;
import com.microsoft.identity.client.CurrentAccountResult;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.ICurrentAccountResult;
import com.microsoft.identity.client.IPublicClientApplication;
import com.microsoft.identity.client.ISingleAccountPublicClientApplication;
import com.microsoft.identity.client.MultiTenantAccount;
import com.microsoft.identity.client.Prompt;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.SignInParameters;
import com.microsoft.identity.client.SilentAuthenticationCallback;
import com.microsoft.identity.client.TokenParameters;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.internal.AsyncResult;
import com.microsoft.identity.client.internal.CommandParametersAdapter;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.controllers.MSALControllerFactory;
import com.microsoft.identity.client.internal.controllers.MsalExceptionAdapter;
import com.microsoft.identity.common.adal.internal.util.JsonExtensions;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.crypto.AndroidAuthSdkStorageEncryptionManager;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.commands.GetCurrentAccountCommand;
import com.microsoft.identity.common.internal.commands.RemoveCurrentAccountCommand;
import com.microsoft.identity.common.internal.migration.TokenMigrationCallback;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.DeviceCodeFlowCommandCallback;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.controllers.CommandDispatcher;
import com.microsoft.identity.common.java.controllers.IControllerFactory;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.java.result.LocalAuthenticationResult;
import com.microsoft.identity.common.java.util.ResultFuture;
import com.microsoft.identity.common.logging.Logger;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class SingleAccountPublicClientApplication
extends PublicClientApplication
implements ISingleAccountPublicClientApplication {
    private static final String TAG = SingleAccountPublicClientApplication.class.getSimpleName();
    public static final String SINGLE_ACCOUNT_CREDENTIAL_SHARED_PREFERENCES = "com.microsoft.identity.client.single_account_credential_cache";
    public static final String CURRENT_ACCOUNT_SHARED_PREFERENCE_KEY = "com.microsoft.identity.client.single_account_credential_cache.current_account";
    private SharedPreferencesFileManager sharedPreferencesFileManager;

    protected SingleAccountPublicClientApplication(@NonNull PublicClientApplicationConfiguration config) throws MsalClientException {
        super(config);
        this.initializeSharedPreferenceFileManager(config.getAppContext());
    }

    private void initializeSharedPreferenceFileManager(@NonNull Context context) {
        this.sharedPreferencesFileManager = new SharedPreferencesFileManager(context, SINGLE_ACCOUNT_CREDENTIAL_SHARED_PREFERENCES, (IKeyAccessor)new AndroidAuthSdkStorageEncryptionManager(context));
    }

    @Override
    public void getCurrentAccountAsync(@NonNull ISingleAccountPublicClientApplication.CurrentAccountCallback callback) {
        this.getCurrentAccountAsyncInternal(callback, "922");
    }

    private void getCurrentAccountAsyncInternal(final @NonNull ISingleAccountPublicClientApplication.CurrentAccountCallback callback, final @NonNull String publicApiId) {
        final String methodTag = TAG + ":getCurrentAccountAsyncInternal";
        TokenMigrationCallback migrationCallback = new TokenMigrationCallback(){

            public void onMigrationFinished(int numberOfAccountsMigrated) {
                CommandParameters params = CommandParametersAdapter.createCommandParameters(SingleAccountPublicClientApplication.this.mPublicClientConfiguration, SingleAccountPublicClientApplication.this.mPublicClientConfiguration.getOAuth2TokenCache());
                GetCurrentAccountCommand command2 = new GetCurrentAccountCommand(params, (IControllerFactory)new MSALControllerFactory(SingleAccountPublicClientApplication.this.mPublicClientConfiguration), (CommandCallback)new CommandCallback<List<ICacheRecord>, BaseException>(){

                    public void onTaskCompleted(List<ICacheRecord> result) {
                        MultiTenantAccount oldAccount = null;
                        boolean forceNotify = false;
                        try {
                            oldAccount = SingleAccountPublicClientApplication.this.getPersistedCurrentAccount();
                        }
                        catch (NullPointerException e) {
                            Logger.error((String)methodTag, (String)"Failed to load Persisted Current Account", (Throwable)e);
                            SingleAccountPublicClientApplication.this.sharedPreferencesFileManager.remove(SingleAccountPublicClientApplication.CURRENT_ACCOUNT_SHARED_PREFERENCE_KEY);
                            forceNotify = true;
                        }
                        SingleAccountPublicClientApplication.this.persistCurrentAccount(result);
                        SingleAccountPublicClientApplication.this.checkCurrentAccountNotifyCallback(callback, result, oldAccount, forceNotify);
                    }

                    public void onError(BaseException exception) {
                        callback.onError(MsalExceptionAdapter.msalExceptionFromBaseException(exception));
                    }

                    public void onCancel() {
                    }
                }, publicApiId);
                CommandDispatcher.submitSilent((BaseCommand)command2);
            }
        };
        this.performMigration(migrationCallback);
    }

    @Override
    public ICurrentAccountResult getCurrentAccount() throws InterruptedException, MsalException {
        MsalUtils.throwOnMainThread("getCurrentAccount");
        final ResultFuture future = new ResultFuture();
        this.getCurrentAccountAsyncInternal(new ISingleAccountPublicClientApplication.CurrentAccountCallback(){

            @Override
            public void onAccountLoaded(@Nullable IAccount activeAccount) {
                CurrentAccountResult currentAccountResult = new CurrentAccountResult(activeAccount, null, false);
                future.setResult(new AsyncResult<CurrentAccountResult>(currentAccountResult, null));
            }

            @Override
            public void onAccountChanged(@Nullable IAccount priorAccount, @Nullable IAccount currentAccount) {
                CurrentAccountResult currentAccountResult = new CurrentAccountResult(currentAccount, priorAccount, false);
                future.setResult(new AsyncResult<CurrentAccountResult>(currentAccountResult, null));
            }

            @Override
            public void onError(@NonNull MsalException exception) {
                future.setResult(new AsyncResult<Object>(null, exception));
            }
        }, "921");
        try {
            AsyncResult result = (AsyncResult)future.get();
            if (result.getSuccess()) {
                return (ICurrentAccountResult)result.getResult();
            }
            throw result.getException();
        }
        catch (ExecutionException e) {
            throw new MsalClientException("unknown_error", "Unknown exception while fetching current account.", e);
        }
    }

    private void checkCurrentAccountNotifyCallback(@NonNull ISingleAccountPublicClientApplication.CurrentAccountCallback callback, @Nullable List<ICacheRecord> newAccountRecords, @Nullable MultiTenantAccount oldAccount, boolean forceNotify) {
        MultiTenantAccount newAccount;
        MultiTenantAccount multiTenantAccount = newAccount = newAccountRecords == null ? null : this.getAccountFromICacheRecordList(newAccountRecords);
        if (forceNotify || !this.isHomeAccountIdMatching(oldAccount, newAccount)) {
            callback.onAccountChanged(oldAccount, newAccount);
        }
        callback.onAccountLoaded(newAccount);
    }

    @Override
    public void signIn(@NonNull SignInParameters signInParameters) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount != null) {
            signInParameters.getCallback().onError(new MsalClientException("invalid_parameter", "An account is already signed in."));
            return;
        }
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(signInParameters.getActivity(), null, signInParameters.getScopes(), null, signInParameters.getPrompt(), null, null, null, signInParameters.getCallback(), signInParameters.getLoginHint(), null);
        if (signInParameters.getPrompt() == null) {
            this.acquireTokenInternal(acquireTokenParameters, "132");
        } else {
            this.acquireTokenInternal(acquireTokenParameters, "133");
        }
    }

    @Override
    @Deprecated
    public void signIn(@NonNull Activity activity, @Nullable String loginHint, @NonNull String[] scopes, @NonNull AuthenticationCallback callback) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount != null) {
            callback.onError(new MsalClientException("invalid_parameter", "An account is already signed in."));
            return;
        }
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(activity, null, Arrays.asList(scopes), null, null, null, null, null, callback, loginHint, null);
        this.acquireTokenInternal(acquireTokenParameters, "123");
    }

    @Override
    @Deprecated
    public void signIn(@NonNull Activity activity, @Nullable String loginHint, @NonNull String[] scopes, @Nullable Prompt prompt, @NonNull AuthenticationCallback callback) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount != null) {
            callback.onError(new MsalClientException("invalid_parameter", "An account is already signed in."));
            return;
        }
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(activity, null, Arrays.asList(scopes), null, prompt, null, null, null, callback, loginHint, null);
        this.acquireTokenInternal(acquireTokenParameters, "130");
    }

    @Override
    public void signInAgain(@NonNull SignInParameters signInParameters) {
        MultiTenantAccount persistedCurrentAccount = this.getPersistedCurrentAccount();
        if (persistedCurrentAccount == null) {
            signInParameters.getCallback().onError(new MsalClientException("no_current_account", "There is no signed in account."));
            return;
        }
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(signInParameters.getActivity(), null, signInParameters.getScopes(), (IAccount)persistedCurrentAccount, signInParameters.getPrompt(), null, null, null, signInParameters.getCallback(), null, null);
        if (signInParameters.getPrompt() == null) {
            this.acquireTokenInternal(acquireTokenParameters, "134");
        } else {
            this.acquireTokenInternal(acquireTokenParameters, "135");
        }
    }

    @Override
    @Deprecated
    public void signInAgain(@NonNull Activity activity, @NonNull String[] scopes, @Nullable Prompt prompt, @NonNull AuthenticationCallback callback) {
        MultiTenantAccount persistedCurrentAccount = this.getPersistedCurrentAccount();
        if (persistedCurrentAccount == null) {
            callback.onError(new MsalClientException("no_current_account", "There is no signed in account."));
            return;
        }
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(activity, null, Arrays.asList(scopes), (IAccount)persistedCurrentAccount, prompt, null, null, null, callback, null, null);
        this.acquireTokenInternal(acquireTokenParameters, "131");
    }

    protected CommandCallback<ILocalAuthenticationResult, BaseException> getCommandCallback(final @NonNull SilentAuthenticationCallback authenticationCallback, final @NonNull TokenParameters tokenParameters) {
        return new CommandCallback<ILocalAuthenticationResult, BaseException>(){

            public void onTaskCompleted(@NonNull ILocalAuthenticationResult localAuthenticationResult) {
                if (authenticationCallback == null) {
                    throw new IllegalStateException("callback cannot be null or empty");
                }
                SingleAccountPublicClientApplication.this.persistCurrentAccount(localAuthenticationResult.getCacheRecordWithTenantProfileData());
                SingleAccountPublicClientApplication.this.postAuthResult(localAuthenticationResult, tokenParameters, authenticationCallback);
            }

            public void onError(BaseException exception) {
                MsalException msalException = MsalExceptionAdapter.msalExceptionFromBaseException(exception);
                if (authenticationCallback == null) {
                    throw new IllegalStateException("callback cannot be null or empty");
                }
                authenticationCallback.onError(msalException);
            }

            public void onCancel() {
                if (!(authenticationCallback instanceof AuthenticationCallback)) {
                    throw new IllegalStateException("Silent requests cannot be cancelled.");
                }
                ((AuthenticationCallback)authenticationCallback).onCancel();
            }
        };
    }

    private boolean isHomeAccountIdMatching(@Nullable IAccount firstAccount, @Nullable IAccount secondAccount) {
        MultiTenantAccount firstMultiTenantAccount = firstAccount instanceof MultiTenantAccount ? (MultiTenantAccount)firstAccount : null;
        MultiTenantAccount secondMultiTenantAccount = secondAccount instanceof MultiTenantAccount ? (MultiTenantAccount)secondAccount : null;
        String firstMultiTenantAccountId = firstMultiTenantAccount == null ? "" : firstMultiTenantAccount.getHomeAccountId();
        String secondMultiTenantAccountId = secondMultiTenantAccount == null ? "" : secondMultiTenantAccount.getHomeAccountId();
        return firstMultiTenantAccountId.equalsIgnoreCase(secondMultiTenantAccountId);
    }

    @Override
    public void signOut(@NonNull ISingleAccountPublicClientApplication.SignOutCallback callback) {
        this.signOutInternal(callback, "928");
    }

    void signOutInternal(final @NonNull ISingleAccountPublicClientApplication.SignOutCallback callback, @NonNull String publicApiId) {
        MultiTenantAccount persistedCurrentAccount = this.getPersistedCurrentAccount();
        if (persistedCurrentAccount == null) {
            callback.onError(new MsalClientException("no_current_account", "There is no signed in account."));
            return;
        }
        AccountRecord requestAccountRecord = new AccountRecord();
        requestAccountRecord.setEnvironment(persistedCurrentAccount.getEnvironment());
        requestAccountRecord.setHomeAccountId(persistedCurrentAccount.getHomeAccountId());
        RemoveAccountCommandParameters params = CommandParametersAdapter.createRemoveAccountCommandParameters(this.mPublicClientConfiguration, this.mPublicClientConfiguration.getOAuth2TokenCache(), requestAccountRecord);
        RemoveCurrentAccountCommand command2 = new RemoveCurrentAccountCommand(params, (IControllerFactory)new MSALControllerFactory(this.mPublicClientConfiguration), (CommandCallback)new CommandCallback<Boolean, BaseException>(){

            public void onError(BaseException error) {
                callback.onError(MsalExceptionAdapter.msalExceptionFromBaseException(error));
            }

            public void onTaskCompleted(Boolean result) {
                SingleAccountPublicClientApplication.this.persistCurrentAccount(null);
                callback.onSignOut();
            }

            public void onCancel() {
            }
        }, publicApiId);
        CommandDispatcher.submitSilent((BaseCommand)command2);
    }

    @Override
    public boolean signOut() throws MsalException, InterruptedException {
        MsalUtils.throwOnMainThread("signOut");
        final ResultFuture future = new ResultFuture();
        this.signOutInternal(new ISingleAccountPublicClientApplication.SignOutCallback(){

            @Override
            public void onSignOut() {
                future.setResult(new AsyncResult<Boolean>(true, null));
            }

            @Override
            public void onError(@NonNull MsalException exception) {
                future.setResult(new AsyncResult<Boolean>(false, exception));
            }
        }, "927");
        try {
            AsyncResult result = (AsyncResult)future.get();
            if (result.getSuccess()) {
                return (Boolean)result.getResult();
            }
            throw result.getException();
        }
        catch (ExecutionException e) {
            throw new MsalClientException("unknown_error", "Unexpected error during signOut.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiTenantAccount getPersistedCurrentAccount() {
        Class<SingleAccountPublicClientApplication> clazz = SingleAccountPublicClientApplication.class;
        synchronized (SingleAccountPublicClientApplication.class) {
            String currentAccountJsonString = this.sharedPreferencesFileManager.getString(CURRENT_ACCOUNT_SHARED_PREFERENCE_KEY);
            if (StringExtensions.isNullOrBlank((String)currentAccountJsonString)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            List cacheRecordList = JsonExtensions.getICacheRecordListFromJsonString((String)currentAccountJsonString);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getAccountFromICacheRecordList(cacheRecordList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistCurrentAccount(@Nullable List<ICacheRecord> cacheRecords) {
        Class<SingleAccountPublicClientApplication> clazz = SingleAccountPublicClientApplication.class;
        synchronized (SingleAccountPublicClientApplication.class) {
            if (cacheRecords == null || cacheRecords.size() == 0) {
                this.sharedPreferencesFileManager.clear();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Logger.info((String)TAG, (String)("persisting cache records with size " + cacheRecords.size()));
            String currentAccountJsonString = JsonExtensions.getJsonStringFromICacheRecordList(cacheRecords);
            this.sharedPreferencesFileManager.putString(CURRENT_ACCOUNT_SHARED_PREFERENCE_KEY, currentAccountJsonString);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Nullable
    private MultiTenantAccount getAccountFromICacheRecordList(@NonNull List<ICacheRecord> cacheRecords) {
        String methodTag = TAG + ":getAccountFromICacheRecords";
        if (cacheRecords.size() == 0) {
            return null;
        }
        List<IAccount> account = AccountAdapter.adapt(cacheRecords);
        if (account.size() != 1) {
            Logger.verbose((String)methodTag, (String)"Returned cacheRecords were adapted into multiple IAccount. This is unexpected in Single account mode.Returning the first adapted account.");
        }
        if (!account.isEmpty()) {
            return (MultiTenantAccount)account.get(0);
        }
        return null;
    }

    @Override
    public void acquireToken(@NonNull AcquireTokenParameters acquireTokenParameters) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount != null) {
            if (acquireTokenParameters.getAccount() == null && StringExtensions.isNullOrBlank((String)acquireTokenParameters.getLoginHint())) {
                acquireTokenParameters.getCallback().onError(new MsalClientException("current_account_mismatch", "The signed in account does not match with the provided account."));
                return;
            }
            if (acquireTokenParameters.getAccount() != null && !this.isHomeAccountIdMatching(persistedAccount, acquireTokenParameters.getAccount())) {
                acquireTokenParameters.getCallback().onError(new MsalClientException("current_account_mismatch", "The signed in account does not match with the provided account."));
                return;
            }
            if (!StringExtensions.isNullOrBlank((String)acquireTokenParameters.getLoginHint()) && !persistedAccount.getUsername().equalsIgnoreCase(acquireTokenParameters.getLoginHint())) {
                acquireTokenParameters.getCallback().onError(new MsalClientException("current_account_mismatch", "The signed in account does not match with the provided account."));
                return;
            }
        }
        this.acquireTokenInternal(acquireTokenParameters, "124");
    }

    @Override
    @Deprecated
    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @NonNull AuthenticationCallback callback) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            callback.onError(new MsalClientException("no_current_account", "There is no signed in account."));
            return;
        }
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(activity, null, Arrays.asList(scopes), (IAccount)this.getPersistedCurrentAccount(), null, null, null, null, callback, null, null);
        this.acquireTokenInternal(acquireTokenParameters, "125");
    }

    @Override
    @Deprecated
    public void acquireTokenSilentAsync(@NonNull String[] scopes, @NonNull String authority, @NonNull SilentAuthenticationCallback callback) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            callback.onError(new MsalClientException("no_current_account", "There is no signed in account."));
            return;
        }
        AcquireTokenSilentParameters acquireTokenSilentParameters = this.buildAcquireTokenSilentParameters(scopes, persistedAccount, authority, false, null, callback);
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, "26");
    }

    @Override
    @Deprecated
    @WorkerThread
    public IAuthenticationResult acquireTokenSilent(@NonNull String[] scopes, @NonNull String authority) throws MsalException, InterruptedException {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            throw new MsalClientException("no_current_account", "There is no signed in account.");
        }
        return this.acquireTokenSilentSyncInternal(scopes, authority, persistedAccount, false, "25");
    }

    @Override
    public void acquireTokenSilentAsync(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            acquireTokenSilentParameters.getCallback().onError(new MsalClientException("no_current_account", "There is no signed in account."));
            return;
        }
        if (!this.isHomeAccountIdMatching(persistedAccount, acquireTokenSilentParameters.getAccount())) {
            acquireTokenSilentParameters.getCallback().onError(new MsalClientException("current_account_mismatch", "The signed in account does not match with the provided account."));
            return;
        }
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, "24");
    }

    @Override
    public IAuthenticationResult acquireTokenSilent(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) throws InterruptedException, MsalException {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            throw new MsalClientException("no_current_account", "There is no signed in account.");
        }
        if (!this.isHomeAccountIdMatching(persistedAccount, acquireTokenSilentParameters.getAccount())) {
            throw new MsalClientException("current_account_mismatch", "The signed in account does not match with the provided account.");
        }
        return this.acquireTokenSilentInternal(acquireTokenSilentParameters, "23");
    }

    @Override
    protected DeviceCodeFlowCommandCallback getDeviceCodeFlowCommandCallback(final @NonNull IPublicClientApplication.DeviceCodeFlowCallback callback) {
        return new DeviceCodeFlowCommandCallback<LocalAuthenticationResult, BaseException>(){

            public void onUserCodeReceived(@NonNull String vUri, @NonNull String userCode, @NonNull String message, @NonNull Date sessionExpirationDate) {
                callback.onUserCodeReceived(vUri, userCode, message, sessionExpirationDate);
            }

            public void onTaskCompleted(@NonNull LocalAuthenticationResult tokenResult) {
                IAuthenticationResult convertedResult = AuthenticationResultAdapter.adapt((ILocalAuthenticationResult)tokenResult);
                SingleAccountPublicClientApplication.this.persistCurrentAccount(tokenResult.getCacheRecordWithTenantProfileData());
                callback.onTokenReceived(convertedResult);
            }

            public void onError(@NonNull BaseException exception) {
                MsalException msalException = MsalExceptionAdapter.msalExceptionFromBaseException(exception);
                callback.onError(msalException);
            }

            public void onCancel() {
            }
        };
    }
}

