/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.content.Context;
import android.content.SharedPreferences;
import com.microsoft.windowsazure.messaging.R;
import com.microsoft.windowsazure.messaging.notificationhubs.Installation;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationVisitor;
import com.microsoft.windowsazure.messaging.notificationhubs.Taggable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class TagVisitor
implements InstallationVisitor,
Taggable {
    private static final String PREFERENCE_KEY = "tags";
    private SharedPreferences mPreferences;

    public TagVisitor(Context context) {
        this(context.getSharedPreferences(context.getString(R.string.installation_enrichment_file_key), 0));
    }

    TagVisitor(SharedPreferences sharedPreferences) {
        this.mPreferences = sharedPreferences;
    }

    private Set<String> getTagsSet() {
        return new HashSet<String>(this.mPreferences.getStringSet(PREFERENCE_KEY, new HashSet()));
    }

    @Override
    public void visitInstallation(Installation subject) {
        subject.addTags(this.getTagsSet());
    }

    @Override
    public boolean addTag(String tag) {
        return this.addTags(Collections.singletonList(tag));
    }

    @Override
    public boolean addTags(Collection<? extends String> tags) {
        Set<String> set = this.getTagsSet();
        set.addAll(tags);
        this.mPreferences.edit().putStringSet(PREFERENCE_KEY, set).apply();
        return true;
    }

    @Override
    public boolean removeTag(String tag) {
        return this.removeTags(Collections.singletonList(tag));
    }

    @Override
    public boolean removeTags(Collection<? extends String> tags) {
        Set<String> set = this.getTagsSet();
        if (set.removeAll(tags)) {
            this.mPreferences.edit().putStringSet(PREFERENCE_KEY, set).apply();
            return true;
        }
        return false;
    }

    @Override
    public Iterable<String> getTags() {
        return this.getTagsSet();
    }

    @Override
    public void clearTags() {
        this.mPreferences.edit().remove(PREFERENCE_KEY).apply();
    }
}

