/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.content.Context;
import android.content.SharedPreferences;
import com.microsoft.windowsazure.messaging.R;
import com.microsoft.windowsazure.messaging.notificationhubs.Installation;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationVisitor;

public class PushChannelVisitor
implements InstallationVisitor {
    private static final String PREFERENCE_KEY = "pushChannel";
    private final SharedPreferences mPreferences;

    public PushChannelVisitor(Context context) {
        this.mPreferences = context.getSharedPreferences(context.getString(R.string.installation_enrichment_file_key), 0);
    }

    @Override
    public void visitInstallation(Installation subject) {
        subject.setPushChannel(this.getPushChannel());
    }

    public void setPushChannel(String channel) {
        this.mPreferences.edit().putString(PREFERENCE_KEY, channel).apply();
    }

    public String getPushChannel() {
        return this.mPreferences.getString(PREFERENCE_KEY, null);
    }
}

