/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import android.os.Build;
import com.microsoft.windowsazure.messaging.AdmNativeRegistration;
import com.microsoft.windowsazure.messaging.AdmTemplateRegistration;
import com.microsoft.windowsazure.messaging.BaiduNativeRegistration;
import com.microsoft.windowsazure.messaging.BaiduTemplateRegistration;
import com.microsoft.windowsazure.messaging.FcmNativeRegistration;
import com.microsoft.windowsazure.messaging.FcmTemplateRegistration;
import com.microsoft.windowsazure.messaging.FcmV1NativeRegistration;
import com.microsoft.windowsazure.messaging.FcmV1TemplateRegistration;
import com.microsoft.windowsazure.messaging.GcmNativeRegistration;
import com.microsoft.windowsazure.messaging.GcmTemplateRegistration;
import com.microsoft.windowsazure.messaging.Registration;
import com.microsoft.windowsazure.messaging.TemplateRegistration;

public final class PnsSpecificRegistrationFactory {
    private static Registration.RegistrationType mRegistrationType = Registration.RegistrationType.fcmv1;
    private static final PnsSpecificRegistrationFactory mInstance = new PnsSpecificRegistrationFactory();

    private PnsSpecificRegistrationFactory() {
        boolean isAmazondevice;
        boolean bl = isAmazondevice = Build.MANUFACTURER.compareToIgnoreCase("Amazon") == 0;
        if (isAmazondevice) {
            mRegistrationType = Registration.RegistrationType.adm;
        }
    }

    public static PnsSpecificRegistrationFactory getInstance() {
        return mInstance;
    }

    public void setRegistrationType(Registration.RegistrationType type) {
        mRegistrationType = type;
    }

    public Registration.RegistrationType getRegistrationType() {
        return mRegistrationType;
    }

    public Registration createNativeRegistration(String notificationHubPath) {
        return this.createNativeRegistrationForPlatform(notificationHubPath, mRegistrationType);
    }

    public Registration createNativeRegistrationForPlatform(String notificationHubPath, Registration.RegistrationType registrationType) {
        switch (registrationType) {
            case gcm: {
                return new GcmNativeRegistration(notificationHubPath);
            }
            case fcm: {
                return new FcmNativeRegistration(notificationHubPath);
            }
            case fcmv1: {
                return new FcmV1NativeRegistration(notificationHubPath);
            }
            case baidu: {
                return new BaiduNativeRegistration(notificationHubPath);
            }
            case adm: {
                return new AdmNativeRegistration(notificationHubPath);
            }
        }
        throw new AssertionError((Object)"Invalid registration type!");
    }

    public TemplateRegistration createTemplateRegistration(String notificationHubPath) {
        return this.createTemplateRegistrationForPlatform(notificationHubPath, mRegistrationType);
    }

    public TemplateRegistration createTemplateRegistrationForPlatform(String notificationHubPath, Registration.RegistrationType registrationType) {
        switch (registrationType) {
            case gcm: {
                return new GcmTemplateRegistration(notificationHubPath);
            }
            case fcm: {
                return new FcmTemplateRegistration(notificationHubPath);
            }
            case fcmv1: {
                return new FcmV1TemplateRegistration(notificationHubPath);
            }
            case baidu: {
                return new BaiduTemplateRegistration(notificationHubPath);
            }
            case adm: {
                return new AdmTemplateRegistration(notificationHubPath);
            }
        }
        throw new AssertionError((Object)"Invalid registration type!");
    }

    public boolean isTemplateRegistration(String xml) {
        return this.isTemplateRegistrationForPlatform(xml, mRegistrationType);
    }

    public boolean isTemplateRegistrationForPlatform(String xml, Registration.RegistrationType registrationType) {
        String templateRegistrationCustomNode;
        switch (registrationType) {
            case gcm: {
                templateRegistrationCustomNode = "GcmTemplateRegistrationDescription";
                break;
            }
            case fcm: {
                templateRegistrationCustomNode = "GcmTemplateRegistrationDescription";
                break;
            }
            case fcmv1: {
                templateRegistrationCustomNode = "FcmV1TemplateRegistrationDescription";
                break;
            }
            case baidu: {
                templateRegistrationCustomNode = "BaiduTemplateRegistrationDescription";
                break;
            }
            case adm: {
                templateRegistrationCustomNode = "AdmTemplateRegistrationDescription";
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid registration type!");
            }
        }
        return xml.contains("<" + templateRegistrationCustomNode);
    }

    public String getPNSHandleFieldName() {
        switch (mRegistrationType) {
            case gcm: {
                return "GcmRegistrationId";
            }
            case fcm: {
                return "GcmRegistrationId";
            }
            case fcmv1: {
                return "FcmV1RegistrationId";
            }
            case baidu: {
                return "BaiduUserId-BaiduChannelId";
            }
            case adm: {
                return "AdmRegistrationId";
            }
        }
        throw new AssertionError((Object)"Invalid registration type!");
    }

    public String getAPIOrigin() {
        switch (mRegistrationType) {
            case gcm: {
                return "AndroidSdkGcm";
            }
            case fcm: {
                return "AndroidSdkFcm";
            }
            case fcmv1: {
                return "AndroidSdkFcmV1";
            }
            case baidu: {
                return "AndroidSdkBaidu";
            }
            case adm: {
                return "AndroidSdkAdm";
            }
        }
        throw new AssertionError((Object)"Invalid registration type!");
    }
}

