/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.microsoft.windowsazure.messaging.Connection;
import com.microsoft.windowsazure.messaging.ConnectionStringParser;
import com.microsoft.windowsazure.messaging.PnsSpecificRegistrationFactory;
import com.microsoft.windowsazure.messaging.Registration;
import com.microsoft.windowsazure.messaging.RegistrationGoneException;
import com.microsoft.windowsazure.messaging.TemplateRegistration;
import com.microsoft.windowsazure.messaging.Utils;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NotificationHub {
    private static final String STORAGE_PREFIX = "__NH_";
    private static final String REGISTRATION_NAME_STORAGE_KEY = "REG_NAME_";
    private static final String XML_CONTENT_TYPE = "application/atom+xml";
    private static final String STORAGE_VERSION_KEY = "STORAGE_VERSION";
    private static final String STORAGE_VERSION = "1.0.0";
    private static final String PNS_HANDLE_KEY = "PNS_HANDLE";
    private static final String NEW_REGISTRATION_LOCATION_HEADER = "Location";
    private String mNotificationHubPath;
    private String mConnectionString;
    private SharedPreferences mSharedPreferences;
    private boolean mIsRefreshNeeded = false;

    public NotificationHub(String notificationHubPath, String connectionString, Context context) {
        this(notificationHubPath, connectionString, PreferenceManager.getDefaultSharedPreferences((Context)context.getApplicationContext()));
    }

    NotificationHub(String notificationHubPath, String connectionString, SharedPreferences sharedPreferences) {
        this.setConnectionString(connectionString);
        this.setNotificationHubPath(notificationHubPath);
        if (sharedPreferences == null) {
            throw new IllegalArgumentException("sharedPreferences cannot be null");
        }
        this.mSharedPreferences = sharedPreferences;
        this.verifyStorageVersion();
    }

    public Registration register(String pnsHandle, String ... tags) throws Exception {
        if (Utils.isNullOrWhiteSpace(pnsHandle)) {
            throw new IllegalArgumentException("pnsHandle");
        }
        Registration registration = PnsSpecificRegistrationFactory.getInstance().createNativeRegistration(this.mNotificationHubPath);
        registration.setPNSHandle(pnsHandle);
        registration.setName("$Default");
        registration.addTags(tags);
        return this.registerInternal(registration);
    }

    public Registration registerBaidu(String userId, String channelId, String ... tags) throws Exception {
        if (Utils.isNullOrWhiteSpace(userId)) {
            throw new IllegalArgumentException("userId");
        }
        if (Utils.isNullOrWhiteSpace(channelId)) {
            throw new IllegalArgumentException("channelId");
        }
        PnsSpecificRegistrationFactory.getInstance().setRegistrationType(Registration.RegistrationType.baidu);
        return this.register(userId + "-" + channelId, tags);
    }

    public TemplateRegistration registerTemplate(String pnsHandle, String templateName, String template, String ... tags) throws Exception {
        if (Utils.isNullOrWhiteSpace(pnsHandle)) {
            throw new IllegalArgumentException("pnsHandle");
        }
        if (Utils.isNullOrWhiteSpace(templateName)) {
            throw new IllegalArgumentException("templateName");
        }
        if (Utils.isNullOrWhiteSpace(template)) {
            throw new IllegalArgumentException("template");
        }
        TemplateRegistration registration = PnsSpecificRegistrationFactory.getInstance().createTemplateRegistration(this.mNotificationHubPath);
        registration.setPNSHandle(pnsHandle);
        registration.setName(templateName);
        registration.setBodyTemplate(template);
        registration.addTags(tags);
        return (TemplateRegistration)this.registerInternal(registration);
    }

    public TemplateRegistration registerBaiduTemplate(String userId, String channelId, String templateName, String template, String ... tags) throws Exception {
        if (Utils.isNullOrWhiteSpace(userId)) {
            throw new IllegalArgumentException("userId");
        }
        if (Utils.isNullOrWhiteSpace(channelId)) {
            throw new IllegalArgumentException("channelId");
        }
        if (Utils.isNullOrWhiteSpace(templateName)) {
            throw new IllegalArgumentException("templateName");
        }
        if (Utils.isNullOrWhiteSpace(template)) {
            throw new IllegalArgumentException("template");
        }
        PnsSpecificRegistrationFactory.getInstance().setRegistrationType(Registration.RegistrationType.baidu);
        return this.registerTemplate(userId + "-" + channelId, templateName, template, tags);
    }

    public void unregister() throws Exception {
        this.unregisterInternal("$Default");
    }

    public void unregisterTemplate(String templateName) throws Exception {
        if (Utils.isNullOrWhiteSpace(templateName)) {
            throw new IllegalArgumentException("templateName");
        }
        this.unregisterInternal(templateName);
    }

    public void unregisterAll(String pnsHandle) throws Exception {
        this.refreshRegistrationInformation(pnsHandle);
        Set keys = this.mSharedPreferences.getAll().keySet();
        for (String key : keys) {
            if (!key.startsWith("__NH_REG_NAME_")) continue;
            String registrationName = key.substring("__NH_REG_NAME_".length());
            String registrationId = this.mSharedPreferences.getString(key, "");
            this.deleteRegistrationInternal(registrationName, registrationId);
        }
    }

    private void refreshRegistrationInformation(String pnsHandle) throws Exception {
        if (Utils.isNullOrWhiteSpace(pnsHandle)) {
            throw new IllegalArgumentException("pnsHandle");
        }
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        Set keys = this.mSharedPreferences.getAll().keySet();
        for (String key : keys) {
            if (!key.startsWith("__NH_REG_NAME_")) continue;
            editor.remove(key);
        }
        editor.commit();
        Connection conn = new Connection(this.mConnectionString);
        String filter = PnsSpecificRegistrationFactory.getInstance().getPNSHandleFieldName() + " eq '" + pnsHandle + "'";
        String resource = this.mNotificationHubPath + "/Registrations/?$filter=" + URLEncoder.encode(filter, "UTF-8");
        String content = null;
        String response = conn.executeRequest(resource, content, XML_CONTENT_TYPE, "GET", new AbstractMap.SimpleEntry[0]);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return null;
            }
        });
        Document doc = builder.parse(new InputSource(new StringReader(response)));
        doc.getDocumentElement().normalize();
        Element root = doc.getDocumentElement();
        NodeList entries = root.getElementsByTagName("entry");
        for (int i = 0; i < entries.getLength(); ++i) {
            Registration.RegistrationType currentPlatform;
            Element entry = (Element)entries.item(i);
            String xml = Utils.getXmlString(entry);
            Registration registration = PnsSpecificRegistrationFactory.getInstance().isTemplateRegistration(xml) ? PnsSpecificRegistrationFactory.getInstance().createTemplateRegistration(this.mNotificationHubPath) : PnsSpecificRegistrationFactory.getInstance().createNativeRegistration(this.mNotificationHubPath);
            registration.loadXml(xml, this.mNotificationHubPath);
            if (Utils.isNullOrWhiteSpace(registration.getRegistrationId()) && ((currentPlatform = PnsSpecificRegistrationFactory.getInstance().getRegistrationType()) == Registration.RegistrationType.fcmv1 || currentPlatform == Registration.RegistrationType.fcm || currentPlatform == Registration.RegistrationType.gcm)) {
                Registration.RegistrationType otherPlatformToCheck = currentPlatform == Registration.RegistrationType.fcmv1 ? Registration.RegistrationType.fcm : Registration.RegistrationType.fcmv1;
                registration = PnsSpecificRegistrationFactory.getInstance().isTemplateRegistrationForPlatform(xml, otherPlatformToCheck) ? PnsSpecificRegistrationFactory.getInstance().createTemplateRegistrationForPlatform(this.mNotificationHubPath, otherPlatformToCheck) : PnsSpecificRegistrationFactory.getInstance().createNativeRegistrationForPlatform(this.mNotificationHubPath, otherPlatformToCheck);
                registration.loadXml(xml, this.mNotificationHubPath);
            }
            this.storeRegistrationId(registration.getName(), registration.getRegistrationId(), registration.getPNSHandle());
        }
        this.mIsRefreshNeeded = false;
    }

    public String getConnectionString() {
        return this.mConnectionString;
    }

    public void setConnectionString(String connectionString) {
        if (Utils.isNullOrWhiteSpace(connectionString)) {
            throw new IllegalArgumentException("connectionString");
        }
        try {
            ConnectionStringParser.parse(connectionString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("connectionString", e);
        }
        this.mConnectionString = connectionString;
    }

    public String getNotificationHubPath() {
        return this.mNotificationHubPath;
    }

    public void setNotificationHubPath(String notificationHubPath) {
        if (Utils.isNullOrWhiteSpace(notificationHubPath)) {
            throw new IllegalArgumentException("notificationHubPath");
        }
        this.mNotificationHubPath = notificationHubPath;
    }

    private Registration registerInternal(Registration registration) throws Exception {
        String registrationId;
        if (this.mIsRefreshNeeded) {
            String pNSHandle = this.mSharedPreferences.getString("__NH_PNS_HANDLE", "");
            if (Utils.isNullOrWhiteSpace(pNSHandle)) {
                pNSHandle = registration.getPNSHandle();
            }
            this.refreshRegistrationInformation(pNSHandle);
        }
        if (Utils.isNullOrWhiteSpace(registrationId = this.retrieveRegistrationId(registration.getName()))) {
            registrationId = this.createRegistrationId();
        }
        registration.setRegistrationId(registrationId);
        try {
            return this.upsertRegistrationInternal(registration);
        }
        catch (RegistrationGoneException registrationGoneException) {
            registrationId = this.createRegistrationId();
            registration.setRegistrationId(registrationId);
            return this.upsertRegistrationInternal(registration);
        }
    }

    private void unregisterInternal(String registrationName) throws Exception {
        String registrationId = this.retrieveRegistrationId(registrationName);
        if (!Utils.isNullOrWhiteSpace(registrationId)) {
            this.deleteRegistrationInternal(registrationName, registrationId);
        }
    }

    private Registration upsertRegistrationInternal(Registration registration) throws Exception {
        Connection conn = new Connection(this.mConnectionString);
        String resource = registration.getURI();
        String content = registration.toXml();
        String response = conn.executeRequest(resource, content, XML_CONTENT_TYPE, "PUT", new AbstractMap.SimpleEntry[0]);
        boolean isTemplateRegistration = PnsSpecificRegistrationFactory.getInstance().isTemplateRegistration(response);
        Registration result = isTemplateRegistration ? PnsSpecificRegistrationFactory.getInstance().createTemplateRegistration(this.mNotificationHubPath) : PnsSpecificRegistrationFactory.getInstance().createNativeRegistration(this.mNotificationHubPath);
        result.loadXml(response, this.mNotificationHubPath);
        this.storeRegistrationId(result.getName(), result.getRegistrationId(), registration.getPNSHandle());
        return result;
    }

    private String createRegistrationId() throws Exception {
        Connection conn = new Connection(this.mConnectionString);
        String resource = this.mNotificationHubPath + "/registrationids/";
        String response = conn.executeRequest(resource, null, XML_CONTENT_TYPE, "POST", NEW_REGISTRATION_LOCATION_HEADER, new AbstractMap.SimpleEntry[0]);
        URI regIdUri = new URI(response);
        String[] pathFragments = regIdUri.getPath().split("/");
        String result = pathFragments[pathFragments.length - 1];
        return result;
    }

    private void deleteRegistrationInternal(String registrationName, String registrationId) throws Exception {
        Connection conn = new Connection(this.mConnectionString);
        String resource = this.mNotificationHubPath + "/Registrations/" + registrationId;
        conn.executeRequest(resource, null, XML_CONTENT_TYPE, "DELETE", new AbstractMap.SimpleEntry<String, String>("If-Match", "*"));
        this.removeRegistrationId(registrationName);
    }

    private String retrieveRegistrationId(String registrationName) throws Exception {
        return this.mSharedPreferences.getString("__NH_REG_NAME_" + registrationName, null);
    }

    private void storeRegistrationId(String registrationName, String registrationId, String pNSHandle) throws Exception {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString("__NH_REG_NAME_" + registrationName, registrationId);
        editor.putString("__NH_PNS_HANDLE", pNSHandle);
        editor.putString("__NH_STORAGE_VERSION", STORAGE_VERSION);
        editor.commit();
    }

    private void removeRegistrationId(String registrationName) throws Exception {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.remove("__NH_REG_NAME_" + registrationName);
        editor.commit();
    }

    private void verifyStorageVersion() {
        String currentStorageVersion = this.mSharedPreferences.getString("__NH_STORAGE_VERSION", "");
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        if (!currentStorageVersion.equals(STORAGE_VERSION)) {
            Set keys = this.mSharedPreferences.getAll().keySet();
            for (String key : keys) {
                if (!key.startsWith(STORAGE_PREFIX)) continue;
                editor.remove(key);
            }
        }
        editor.commit();
        this.mIsRefreshNeeded = true;
    }
}

