/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.content.Context;
import android.content.SharedPreferences;
import com.microsoft.windowsazure.messaging.R;
import com.microsoft.windowsazure.messaging.notificationhubs.Installation;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationVisitor;

public class PlatformVisitor
implements InstallationVisitor {
    private static final String PREFERENCE_KEY = "platform";
    private final SharedPreferences mPreferences;

    public PlatformVisitor(Context context) {
        this.mPreferences = context.getSharedPreferences(context.getString(R.string.installation_enrichment_file_key), 0);
    }

    @Override
    public void visitInstallation(Installation subject) {
        String selectedPlatform = this.getPlatform();
        if (selectedPlatform == null) {
            return;
        }
        subject.setPlatform(selectedPlatform);
    }

    public void setPlatform(String platform) {
        this.mPreferences.edit().putString(PREFERENCE_KEY, platform).apply();
    }

    public String getPlatform() {
        return this.mPreferences.getString(PREFERENCE_KEY, null);
    }
}

