/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import com.microsoft.windowsazure.messaging.Registration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FcmV1NativeRegistration
extends Registration {
    private static final String FCM_V1_NATIVE_REGISTRATION_CUSTOM_NODE = "FcmV1RegistrationDescription";
    static final String FCM_V1_HANDLE_NODE = "FcmV1RegistrationId";

    FcmV1NativeRegistration(String notificationHubPath) {
        super(notificationHubPath);
        this.mRegistrationType = Registration.RegistrationType.fcmv1;
    }

    @Override
    protected String getSpecificPayloadNodeName() {
        return FCM_V1_NATIVE_REGISTRATION_CUSTOM_NODE;
    }

    @Override
    protected void appendCustomPayload(Document doc, Element registrationDescription) {
        this.appendNodeWithValue(doc, registrationDescription, FCM_V1_HANDLE_NODE, this.getPNSHandle());
    }

    @Override
    protected void loadCustomXmlData(Element payloadNode) {
        this.setPNSHandle(FcmV1NativeRegistration.getNodeValue(payloadNode, FCM_V1_HANDLE_NODE));
        this.setName("$Default");
    }
}

