/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.content.Context;
import android.content.SharedPreferences;
import com.microsoft.windowsazure.messaging.R;
import com.microsoft.windowsazure.messaging.notificationhubs.Installation;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationVisitor;

class UserIdVisitor
implements InstallationVisitor {
    private static final String PREFERENCE_KEY = "userId";
    private final SharedPreferences mPreferences;

    public UserIdVisitor(Context context) {
        this.mPreferences = context.getSharedPreferences(context.getString(R.string.installation_enrichment_file_key), 0);
    }

    @Override
    public void visitInstallation(Installation subject) {
        subject.setUserId(this.getUserId());
    }

    public String getUserId() {
        return this.mPreferences.getString(PREFERENCE_KEY, null);
    }

    public boolean setUserId(String userId) {
        if (userId != null && !userId.equals(this.getUserId()) || userId == null && this.getUserId() != null) {
            this.mPreferences.edit().putString(PREFERENCE_KEY, userId).apply();
            return true;
        }
        return false;
    }
}

