/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.util.Log;
import com.microsoft.windowsazure.messaging.R;
import com.microsoft.windowsazure.messaging.notificationhubs.DebounceInstallationAdapter;
import com.microsoft.windowsazure.messaging.notificationhubs.IdAssignmentVisitor;
import com.microsoft.windowsazure.messaging.notificationhubs.Installation;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationAdapter;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationTemplate;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationVisitor;
import com.microsoft.windowsazure.messaging.notificationhubs.NetworkStateHelper;
import com.microsoft.windowsazure.messaging.notificationhubs.NotificationHubExtension;
import com.microsoft.windowsazure.messaging.notificationhubs.NotificationHubInstallationAdapter;
import com.microsoft.windowsazure.messaging.notificationhubs.NotificationListener;
import com.microsoft.windowsazure.messaging.notificationhubs.PushChannelValidationAdapter;
import com.microsoft.windowsazure.messaging.notificationhubs.PushChannelVisitor;
import com.microsoft.windowsazure.messaging.notificationhubs.TagVisitor;
import com.microsoft.windowsazure.messaging.notificationhubs.TemplateVisitor;
import com.microsoft.windowsazure.messaging.notificationhubs.UserIdVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class NotificationHub {
    private static NotificationHub sInstance;
    private NotificationListener mListener;
    private final List<InstallationVisitor> mVisitors = new ArrayList<InstallationVisitor>();
    private PushChannelVisitor mPushChannelVisitor;
    private TagVisitor mTagVisitor;
    private TemplateVisitor mTemplateVisitor;
    private IdAssignmentVisitor mIdAssignmentVisitor;
    private UserIdVisitor mUserIdVisitor;
    private InstallationAdapter mAdapter;
    private Application mApplication;
    private SharedPreferences mPreferences;
    private static final String IS_ENABLED_PREFERENCE_KEY = "isEnabled";
    private InstallationAdapter.Listener mOnSavedInstallation;
    private InstallationAdapter.ErrorListener mOnInstallationFailure = new InstallationAdapter.ErrorListener(){

        @Override
        public void onInstallationSaveError(Exception e) {
            Log.e((String)"ANH", (String)("unable to save installation: " + e.toString()));
        }
    };

    NotificationHub() {
        this.mOnSavedInstallation = new InstallationAdapter.Listener(){

            @Override
            public void onInstallationSaved(Installation i) {
                Log.i((String)"ANH", (String)"updated installation");
            }
        };
    }

    public static synchronized NotificationHub getInstance() {
        if (sInstance == null) {
            sInstance = new NotificationHub();
        }
        return sInstance;
    }

    synchronized void registerApplication(Application application) {
        if (this.mApplication == application) {
            return;
        }
        this.mApplication = application;
        this.mPreferences = this.mApplication.getSharedPreferences(this.mApplication.getString(R.string.installation_enrichment_file_key), 0);
        this.mIdAssignmentVisitor = new IdAssignmentVisitor((Context)this.mApplication);
        this.useInstanceVisitor(this.mIdAssignmentVisitor);
        this.mTagVisitor = new TagVisitor((Context)this.mApplication);
        this.useInstanceVisitor(this.mTagVisitor);
        this.mTemplateVisitor = new TemplateVisitor((Context)this.mApplication);
        this.useInstanceVisitor(this.mTemplateVisitor);
        this.mPushChannelVisitor = new PushChannelVisitor((Context)this.mApplication);
        this.useInstanceVisitor(this.mPushChannelVisitor);
        this.mUserIdVisitor = new UserIdVisitor((Context)this.mApplication);
        this.useInstanceVisitor(this.mUserIdVisitor);
        NotificationHubExtension.fetchPushChannel(this);
    }

    public static void start(Application application, String hubName, String connectionString) {
        NotificationHubInstallationAdapter client = new NotificationHubInstallationAdapter((Context)application, hubName, connectionString);
        DebounceInstallationAdapter debouncer = new DebounceInstallationAdapter((Context)application, client);
        PushChannelValidationAdapter pushChannelAdapter = new PushChannelValidationAdapter(debouncer);
        NotificationHub.start(application, pushChannelAdapter);
    }

    public static void start(Application application, InstallationAdapter adapter) {
        final NotificationHub instance = NotificationHub.getInstance();
        instance.mAdapter = adapter;
        instance.registerApplication(application);
        IntentFilter connectivityFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        connectivityFilter.addAction("android.intent.action.AIRPLANE_MODE");
        NetworkStateHelper.getSharedInstance((Context)application).addListener(new NetworkStateHelper.Listener(){

            @Override
            public void onNetworkStateUpdated(boolean connected) {
                if (connected) {
                    instance.beginInstanceInstallationUpdate();
                }
            }
        });
    }

    public static void setListener(NotificationListener listener) {
        NotificationHub.getInstance().setInstanceListener(listener);
    }

    public void setInstanceListener(NotificationListener listener) {
        this.mListener = listener;
    }

    NotificationListener getInstanceListener() {
        return this.mListener;
    }

    public static void setInstallationSavedListener(InstallationAdapter.Listener listener) {
        NotificationHub.getInstance().setInstanceInstallationSavedListener(listener);
    }

    public void setInstanceInstallationSavedListener(InstallationAdapter.Listener listener) {
        this.mOnSavedInstallation = listener;
    }

    public static void setInstallationSaveFailureListener(InstallationAdapter.ErrorListener listener) {
        NotificationHub.getInstance().setInstanceInstallationSaveFailureListener(listener);
    }

    public void setInstanceInstallationSaveFailureListener(InstallationAdapter.ErrorListener listener) {
        this.mOnInstallationFailure = listener;
    }

    static void checkLaunchedFromNotification(Activity activity, Intent intent) {
    }

    public static void useVisitor(InstallationVisitor visitor) {
        NotificationHub.getInstance().useInstanceVisitor(visitor);
    }

    public void useInstanceVisitor(InstallationVisitor visitor) {
        this.mVisitors.add(visitor);
    }

    public static void beginInstallationUpdate() {
        NotificationHub.getInstance().beginInstanceInstallationUpdate();
    }

    public void beginInstanceInstallationUpdate() {
        if (!this.isInstanceEnabled()) {
            return;
        }
        Installation installation = new Installation();
        for (InstallationVisitor visitor : this.mVisitors) {
            visitor.visitInstallation(installation);
        }
        if (this.mAdapter != null) {
            this.mAdapter.saveInstallation(installation, this.mOnSavedInstallation, this.mOnInstallationFailure);
        }
    }

    static void setPushChannel(String token) {
        NotificationHub.getInstance().setInstancePushChannel(token);
    }

    public static String getPushChannel() {
        return NotificationHub.getInstance().getInstancePushChannel();
    }

    void setInstancePushChannel(String token) {
        if (token.equals(this.mPushChannelVisitor.getPushChannel())) {
            return;
        }
        this.mPushChannelVisitor.setPushChannel(token);
        this.beginInstanceInstallationUpdate();
    }

    public String getInstancePushChannel() {
        return this.mPushChannelVisitor.getPushChannel();
    }

    public static String getInstallationId() {
        return NotificationHub.getInstance().getInstanceInstallationId();
    }

    public String getInstanceInstallationId() {
        return this.mIdAssignmentVisitor.getInstallationId();
    }

    public static void setInstallationId(String id) {
        NotificationHub.getInstance().setInstanceInstallationId(id);
    }

    public void setInstanceInstallationId(String id) {
        if (id.equals(this.mIdAssignmentVisitor.getInstallationId())) {
            return;
        }
        this.mIdAssignmentVisitor.setInstallationId(id);
        this.beginInstanceInstallationUpdate();
    }

    public static boolean addTag(String tag) {
        return NotificationHub.getInstance().addInstanceTag(tag);
    }

    public boolean addInstanceTag(String tag) {
        if (this.mTagVisitor.addTag(tag)) {
            this.beginInstanceInstallationUpdate();
            return true;
        }
        return false;
    }

    public static boolean addTags(Collection<? extends String> tags) {
        return NotificationHub.getInstance().addInstanceTags(tags);
    }

    public boolean addInstanceTags(Collection<? extends String> tags) {
        if (this.mTagVisitor.addTags(tags)) {
            this.beginInstanceInstallationUpdate();
            return true;
        }
        return false;
    }

    public static boolean removeTag(String tag) {
        return NotificationHub.getInstance().removeInstanceTag(tag);
    }

    public boolean removeInstanceTag(String tag) {
        if (this.mTagVisitor.removeTag(tag)) {
            this.beginInstanceInstallationUpdate();
            return true;
        }
        return false;
    }

    public static boolean removeTags(Collection<? extends String> tags) {
        return NotificationHub.getInstance().removeInstanceTags(tags);
    }

    public boolean removeInstanceTags(Collection<? extends String> tags) {
        if (this.mTagVisitor.removeTags(tags)) {
            this.beginInstanceInstallationUpdate();
            return true;
        }
        return false;
    }

    public static Iterable<String> getTags() {
        return NotificationHub.getInstance().getInstanceTags();
    }

    public Iterable<String> getInstanceTags() {
        return this.mTagVisitor.getTags();
    }

    public static void clearTags() {
        NotificationHub.getInstance().clearInstanceTags();
    }

    public void clearInstanceTags() {
        if (this.mTagVisitor.getTags().iterator().hasNext()) {
            this.mTagVisitor.clearTags();
            this.beginInstanceInstallationUpdate();
        }
    }

    public static void setEnabled(boolean enable) {
        NotificationHub.getInstance().setInstanceEnabled(enable);
    }

    public void setInstanceEnabled(boolean enable) {
        this.mPreferences.edit().putBoolean(IS_ENABLED_PREFERENCE_KEY, enable).apply();
        if (enable) {
            this.beginInstanceInstallationUpdate();
        }
    }

    public static boolean isEnabled() {
        return NotificationHub.getInstance().isInstanceEnabled();
    }

    public boolean isInstanceEnabled() {
        return this.mPreferences.getBoolean(IS_ENABLED_PREFERENCE_KEY, true);
    }

    public static void setTemplate(String templateName, InstallationTemplate template) {
        NotificationHub.getInstance().setInstanceTemplate(templateName, template);
    }

    public void setInstanceTemplate(String templateName, InstallationTemplate template) {
        this.mTemplateVisitor.setTemplate(templateName, template);
        this.beginInstanceInstallationUpdate();
    }

    public static boolean removeTemplate(String templateName) {
        return NotificationHub.getInstance().removeInstanceTemplate(templateName);
    }

    public boolean removeInstanceTemplate(String templateName) {
        if (this.mTemplateVisitor.removeTemplate(templateName)) {
            this.beginInstanceInstallationUpdate();
            return true;
        }
        return false;
    }

    public static InstallationTemplate getTemplate(String templateName) {
        return NotificationHub.getInstance().getInstanceTemplate(templateName);
    }

    public InstallationTemplate getInstanceTemplate(String templateName) {
        return this.mTemplateVisitor.getTemplate(templateName);
    }

    public static boolean setUserId(String userId) {
        return NotificationHub.getInstance().setInstanceUserId(userId);
    }

    public boolean setInstanceUserId(String userId) {
        if (this.mUserIdVisitor.setUserId(userId)) {
            this.beginInstanceInstallationUpdate();
            return true;
        }
        return false;
    }

    public static String getUserId() {
        return NotificationHub.getInstance().getInstanceUserId();
    }

    public String getInstanceUserId() {
        return this.mUserIdVisitor.getUserId();
    }
}

