/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.content.Context;
import android.content.SharedPreferences;
import com.microsoft.windowsazure.messaging.R;
import com.microsoft.windowsazure.messaging.notificationhubs.Installation;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationTemplate;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

class TemplateVisitor
implements InstallationVisitor {
    private static final String PREFERENCE_KEY = "templates";
    private final SharedPreferences mPreferences;

    public TemplateVisitor(Context context) {
        this(context.getSharedPreferences(String.valueOf(R.string.installation_enrichment_file_key), 0));
    }

    TemplateVisitor(SharedPreferences sharedPreferences) {
        this.mPreferences = sharedPreferences;
    }

    public TemplateVisitor(Context context, Map<String, InstallationTemplate> templates) {
        this(context);
        this.setTemplates(templates);
    }

    @Override
    public void visitInstallation(Installation subject) {
        subject.setTemplates(this.getSharedPreferenceTemplates());
    }

    private Map<String, InstallationTemplate> getSharedPreferenceTemplates() {
        Set preferencesSet = this.mPreferences.getStringSet(PREFERENCE_KEY, new HashSet());
        if (preferencesSet == null) {
            return new HashMap<String, InstallationTemplate>();
        }
        try {
            return TemplateVisitor.deserializeInstallationTemplateFromJson(preferencesSet);
        }
        catch (JSONException ex) {
            throw new RuntimeException("Unable to deserialize installation template", ex);
        }
    }

    public void setTemplate(String templateName, InstallationTemplate template) {
        this.setTemplates(Collections.singletonMap(templateName, template));
    }

    public void setTemplates(Map<String, InstallationTemplate> templates) {
        Map<String, InstallationTemplate> sharedPreferenceTemplates = this.getSharedPreferenceTemplates();
        sharedPreferenceTemplates.putAll(templates);
        HashSet<String> serializedTemplatesSet = new HashSet<String>();
        for (Map.Entry<String, InstallationTemplate> template : sharedPreferenceTemplates.entrySet()) {
            serializedTemplatesSet.add(TemplateVisitor.serializeInstallationTemplateToJson(template.getKey(), template.getValue()));
        }
        this.mPreferences.edit().putStringSet(PREFERENCE_KEY, serializedTemplatesSet).apply();
    }

    public boolean removeTemplate(String templateName) {
        return this.removeTemplates(Collections.singletonList(templateName));
    }

    public boolean removeTemplates(List<String> templates) {
        Map<String, InstallationTemplate> sharedPreferenceTemplates = this.getSharedPreferenceTemplates();
        sharedPreferenceTemplates.keySet().removeAll(templates);
        HashSet<String> serializedTemplatesSet = new HashSet<String>();
        for (Map.Entry<String, InstallationTemplate> installation : sharedPreferenceTemplates.entrySet()) {
            serializedTemplatesSet.add(TemplateVisitor.serializeInstallationTemplateToJson(installation.getKey(), installation.getValue()));
        }
        this.mPreferences.edit().putStringSet(PREFERENCE_KEY, serializedTemplatesSet).apply();
        return true;
    }

    public InstallationTemplate getTemplate(String templateName) {
        Map<String, InstallationTemplate> templates = this.getSharedPreferenceTemplates();
        return templates.get(templateName);
    }

    public Iterable<Map.Entry<String, InstallationTemplate>> getTemplates() {
        return this.getSharedPreferenceTemplates().entrySet();
    }

    public void clearTemplates() {
        this.mPreferences.edit().remove(PREFERENCE_KEY).apply();
    }

    private static String serializeInstallationTemplateToJson(String name, InstallationTemplate installationTemplate) {
        return InstallationTemplate.serialize(name, installationTemplate).toString();
    }

    private static Map<String, InstallationTemplate> deserializeInstallationTemplateFromJson(Set<String> installationTemplatesSet) throws JSONException {
        HashMap<String, InstallationTemplate> templates = new HashMap<String, InstallationTemplate>();
        for (String preferenceString : installationTemplatesSet) {
            JSONObject preference = new JSONObject(preferenceString);
            String name = preference.getString("name");
            InstallationTemplate template = InstallationTemplate.deserialize(preference);
            templates.put(name, template);
        }
        return templates;
    }
}

