/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import com.microsoft.windowsazure.messaging.notificationhubs.Installation;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationAdapter;

public class PushChannelValidationAdapter
implements InstallationAdapter {
    public static final int DEFAULT_MAX_RETRIES = 20;
    private final InstallationAdapter mDecoratedAdapter;
    private final int mMaxRetries;
    private int mRetryCount;

    public PushChannelValidationAdapter(InstallationAdapter decoratedAdapter) {
        this(decoratedAdapter, 20);
    }

    public PushChannelValidationAdapter(InstallationAdapter decoratedAdapter, int maxRetries) {
        this.mMaxRetries = maxRetries;
        this.mRetryCount = 0;
        this.mDecoratedAdapter = decoratedAdapter;
    }

    @Override
    public void saveInstallation(Installation installation, InstallationAdapter.Listener onInstallationSaved, InstallationAdapter.ErrorListener onInstallationSaveError) {
        String pushChannel = installation.getPushChannel();
        if (pushChannel == null || pushChannel.isEmpty()) {
            if (this.mRetryCount++ >= this.mMaxRetries) {
                this.mRetryCount = 0;
                onInstallationSaveError.onInstallationSaveError(new IllegalArgumentException("After " + this.mRetryCount + " retry attempts, Installation does not have a PushChannel."));
            }
            return;
        }
        this.mRetryCount = 0;
        this.mDecoratedAdapter.saveInstallation(installation, onInstallationSaved, onInstallationSaveError);
    }
}

