/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.microsoft.windowsazure.messaging.notificationhubs.BasicNotificationMessage;
import com.microsoft.windowsazure.messaging.notificationhubs.NotificationHub;

public final class FirebaseReceiver
extends FirebaseMessagingService {
    private final NotificationHub mHub;

    public FirebaseReceiver() {
        this(NotificationHub.getInstance());
    }

    public FirebaseReceiver(NotificationHub hub) {
        this.mHub = hub;
    }

    public void onCreate() {
        super.onCreate();
        this.mHub.registerApplication(this.getApplication());
        if (this.mHub.getInstancePushChannel() == null) {
            FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

                public void onComplete(@NonNull Task<InstanceIdResult> task) {
                    if (!task.isSuccessful()) {
                        Log.e((String)"ANH", (String)"unable to fetch FirebaseInstanceId");
                        return;
                    }
                    FirebaseReceiver.this.mHub.setInstancePushChannel(((InstanceIdResult)task.getResult()).getToken());
                }
            });
        }
    }

    public void onMessageReceived(@NonNull RemoteMessage remoteMessage) {
        this.mHub.getInstanceListener().onPushNotificationReceived(this.getApplicationContext(), FirebaseReceiver.getNotificationMessage(remoteMessage));
    }

    public void onNewToken(@NonNull String s) {
        this.mHub.setInstancePushChannel(s);
    }

    static BasicNotificationMessage getNotificationMessage(RemoteMessage remoteMessage) {
        RemoteMessage.Notification notification = remoteMessage.getNotification();
        String title = null;
        String body = null;
        if (notification != null) {
            title = notification.getTitle();
            body = notification.getBody();
        }
        return new BasicNotificationMessage(title, body, remoteMessage.getData());
    }
}

