/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import com.microsoft.windowsazure.messaging.Registration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FcmNativeRegistration
extends Registration {
    private static final String FCM_NATIVE_REGISTRATION_CUSTOM_NODE = "GcmRegistrationDescription";
    static final String FCM_HANDLE_NODE = "GcmRegistrationId";

    FcmNativeRegistration(String notificationHubPath) {
        super(notificationHubPath);
        this.mRegistrationType = Registration.RegistrationType.fcm;
    }

    @Override
    protected String getSpecificPayloadNodeName() {
        return FCM_NATIVE_REGISTRATION_CUSTOM_NODE;
    }

    @Override
    protected void appendCustomPayload(Document doc, Element registrationDescription) {
        this.appendNodeWithValue(doc, registrationDescription, FCM_HANDLE_NODE, this.getPNSHandle());
    }

    @Override
    protected void loadCustomXmlData(Element payloadNode) {
        this.setPNSHandle(FcmNativeRegistration.getNodeValue(payloadNode, FCM_HANDLE_NODE));
        this.setName("$Default");
    }
}

