/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.ClientError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Header;
import com.android.volley.NetworkError;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.ServerError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.microsoft.windowsazure.messaging.notificationhubs.AuthorizationException;
import com.microsoft.windowsazure.messaging.notificationhubs.ClientException;
import com.microsoft.windowsazure.messaging.notificationhubs.ConnectionString;
import com.microsoft.windowsazure.messaging.notificationhubs.Installation;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationAdapter;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationPutRequest;
import com.microsoft.windowsazure.messaging.notificationhubs.ServerException;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class NotificationHubInstallationAdapter
implements InstallationAdapter {
    private static final long DEFAULT_INSTALLATION_EXPIRATION_MILLIS = 7776000000L;
    private static final RetryPolicy sDoNotRetry = new DefaultRetryPolicy(1000, 0, 1.0f);
    private static final Set<Integer> sRetriableStatusCodes = new HashSet<Integer>();
    private static final String INSTALLATION_PUT_TAG = "installationPutRequest";
    private final String mHubName;
    private final ConnectionString mConnectionString;
    private final RequestQueue mRequestQueue;
    private final long mInstallationExpirationWindow;
    private final ScheduledExecutorService mScheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> mOutstandingRetry;

    public NotificationHubInstallationAdapter(Context context, String hubName, String connectionString) {
        this(context, hubName, connectionString, 7776000000L);
    }

    NotificationHubInstallationAdapter(Context context, String hubName, String connectionString, long installationExpirationWindow) {
        this.mHubName = hubName;
        this.mConnectionString = ConnectionString.parse(connectionString);
        this.mRequestQueue = Volley.newRequestQueue((Context)context.getApplicationContext());
        this.mInstallationExpirationWindow = installationExpirationWindow;
    }

    @Override
    public void saveInstallation(Installation installation, InstallationAdapter.Listener onInstallationSaved, InstallationAdapter.ErrorListener onInstallationSaveError) {
        this.addExpiration(installation);
        this.cancelOutstandingUpdates();
        new RetrySession(installation, 3, onInstallationSaved, onInstallationSaveError).submit();
    }

    void addExpiration(Installation target) {
        if (target.getExpiration() != null) {
            return;
        }
        Date expiration = new Date();
        expiration = new Date(expiration.getTime() + this.mInstallationExpirationWindow);
        target.setExpiration(expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelOutstandingUpdates() {
        NotificationHubInstallationAdapter notificationHubInstallationAdapter = this;
        synchronized (notificationHubInstallationAdapter) {
            if (this.mOutstandingRetry != null) {
                this.mOutstandingRetry.cancel(false);
            }
            this.mRequestQueue.cancelAll((Object)INSTALLATION_PUT_TAG);
        }
    }

    static boolean isRetriable(VolleyError error) {
        if (error instanceof NetworkError || error instanceof TimeoutError) {
            return true;
        }
        return error.networkResponse != null && sRetriableStatusCodes.contains(error.networkResponse.statusCode);
    }

    static Exception convertVolleyException(VolleyError error) {
        if (error instanceof AuthFailureError) {
            return new AuthorizationException((AuthFailureError)error);
        }
        if (error instanceof ClientError) {
            return new ClientException((ClientError)error);
        }
        if (error instanceof ServerError) {
            return new ServerException((ServerError)error);
        }
        if (error instanceof NetworkError) {
            return new IOException(error.getMessage(), error.getCause());
        }
        if (error instanceof ParseError) {
            return new IOException(error.getMessage(), error.getCause());
        }
        if (error instanceof TimeoutError) {
            return new IOException(error.getMessage(), error.getCause());
        }
        return new Exception((Throwable)error);
    }

    static String getRetryAfter(NetworkResponse response) {
        for (Header header : response.allHeaders) {
            String name = header.getName();
            if (!name.equalsIgnoreCase("Retry-After")) continue;
            return header.getValue();
        }
        return null;
    }

    static long parseRetryAfterValue(String retryAfter) {
        try {
            return 1000L * Long.parseLong(retryAfter);
        }
        catch (NumberFormatException e) {
            throw new UnsupportedOperationException("Retry-After must be communicated as a number of seconds", e);
        }
    }

    static {
        sRetriableStatusCodes.add(500);
        sRetriableStatusCodes.add(503);
        sRetriableStatusCodes.add(504);
        sRetriableStatusCodes.add(403);
        sRetriableStatusCodes.add(408);
        sRetriableStatusCodes.add(429);
    }

    private class RetrySession
    implements Response.ErrorListener,
    Response.Listener<JSONObject> {
        private final int mMaxRetries;
        private int mRetry;
        private final Installation mInstallation;
        private final InstallationAdapter.Listener mOnSuccess;
        private final InstallationAdapter.ErrorListener mOnFailure;
        private final long mDefaultWaitTime;

        public RetrySession(Installation installation, int maxRetries, InstallationAdapter.Listener onSuccess, InstallationAdapter.ErrorListener onFailure) {
            this.mMaxRetries = maxRetries;
            this.mInstallation = installation;
            this.mOnSuccess = onSuccess;
            this.mOnFailure = onFailure;
            this.mRetry = 0;
            this.mDefaultWaitTime = 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void submit() {
            InstallationPutRequest request = new InstallationPutRequest(NotificationHubInstallationAdapter.this.mConnectionString, NotificationHubInstallationAdapter.this.mHubName, this.mInstallation, this, this);
            request.addMarker(NotificationHubInstallationAdapter.INSTALLATION_PUT_TAG);
            request.setRetryPolicy(sDoNotRetry);
            NotificationHubInstallationAdapter notificationHubInstallationAdapter = NotificationHubInstallationAdapter.this;
            synchronized (notificationHubInstallationAdapter) {
                NotificationHubInstallationAdapter.this.mOutstandingRetry = null;
                NotificationHubInstallationAdapter.this.mRequestQueue.add((Request)request);
            }
        }

        public void onResponse(JSONObject response) {
            this.mOnSuccess.onInstallationSaved(this.mInstallation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onErrorResponse(VolleyError error) {
            ++this.mRetry;
            if (!NotificationHubInstallationAdapter.isRetriable(error) || this.mRetry > this.mMaxRetries) {
                this.mOnFailure.onInstallationSaveError(NotificationHubInstallationAdapter.convertVolleyException(error));
                return;
            }
            NetworkResponse response = error.networkResponse;
            String rawRetryAfter = null;
            if (response != null) {
                rawRetryAfter = NotificationHubInstallationAdapter.getRetryAfter(response);
            }
            long waitTimeMillis = response == null ? this.mDefaultWaitTime : (rawRetryAfter != null ? NotificationHubInstallationAdapter.parseRetryAfterValue(rawRetryAfter) : (response.statusCode == 429 || response.statusCode == 403 ? 10000L : this.mDefaultWaitTime));
            NotificationHubInstallationAdapter notificationHubInstallationAdapter = NotificationHubInstallationAdapter.this;
            synchronized (notificationHubInstallationAdapter) {
                NotificationHubInstallationAdapter.this.mOutstandingRetry = NotificationHubInstallationAdapter.this.mScheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        RetrySession.this.submit();
                    }
                }, waitTimeMillis, TimeUnit.MILLISECONDS);
            }
        }
    }
}

