/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.content.Context;
import android.content.SharedPreferences;
import com.microsoft.windowsazure.messaging.R;
import com.microsoft.windowsazure.messaging.notificationhubs.Installation;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationAdapter;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DebounceInstallationAdapter
implements InstallationAdapter {
    static final String LAST_ACCEPTED_HASH_KEY = "lastAcceptedHash";
    static final String LAST_ACCEPTED_TIMESTAMP_KEY = "lastAcceptedTimestamp";
    private static final long DEFAULT_DEBOUNCE_INTERVAL = 2000L;
    private static final long DEFAULT_INSTALLATION_STALE_MILLIS = 86400000L;
    private final ScheduledExecutorService mScheduler = Executors.newScheduledThreadPool(1);
    private InstallationAdapter mInstallationAdapter;
    private long mInterval;
    private ScheduledFuture<?> mSchedFuture;
    private SharedPreferences mPreferences;
    private long mInstallationStaleMillis;

    public DebounceInstallationAdapter(Context context, InstallationAdapter installationAdapter) {
        this(context, installationAdapter, 2000L);
    }

    public DebounceInstallationAdapter(Context context, InstallationAdapter installationAdapter, long interval) {
        this(installationAdapter, interval, context.getSharedPreferences(context.getString(R.string.installation_enrichment_file_key), 4));
    }

    DebounceInstallationAdapter(InstallationAdapter installationAdapter, long interval, SharedPreferences sharedPreferences) {
        this.mInstallationAdapter = installationAdapter;
        this.mInterval = interval;
        this.mInstallationStaleMillis = 86400000L;
        this.mPreferences = sharedPreferences;
    }

    void setInstallationStaleWindow(long millis) {
        this.mInstallationStaleMillis = millis;
    }

    @Override
    public synchronized void saveInstallation(final Installation installation, final InstallationAdapter.Listener onInstallationSaved, final InstallationAdapter.ErrorListener onInstallationSaveError) {
        boolean lastAcceptedIsRecent;
        if (this.mSchedFuture != null && !this.mSchedFuture.isDone()) {
            this.mSchedFuture.cancel(true);
        }
        final int currentHash = installation.hashCode();
        int recentHash = this.getLastAcceptedHash();
        boolean sameAsLastAccepted = recentHash != 0 && recentHash == currentHash;
        final long currentTime = new Date().getTime();
        boolean bl = lastAcceptedIsRecent = currentTime < this.getLastAcceptedTimestamp() + this.mInstallationStaleMillis;
        if (sameAsLastAccepted && lastAcceptedIsRecent) {
            return;
        }
        this.mSchedFuture = this.mScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    InstallationAdapter.Listener completed = new InstallationAdapter.Listener(){

                        @Override
                        public void onInstallationSaved(Installation i) {
                            DebounceInstallationAdapter.this.mPreferences.edit().putInt(DebounceInstallationAdapter.LAST_ACCEPTED_HASH_KEY, currentHash).apply();
                            DebounceInstallationAdapter.this.mPreferences.edit().putLong(DebounceInstallationAdapter.LAST_ACCEPTED_TIMESTAMP_KEY, currentTime).apply();
                            onInstallationSaved.onInstallationSaved(i);
                        }
                    };
                    DebounceInstallationAdapter.this.mInstallationAdapter.saveInstallation(installation, completed, onInstallationSaveError);
                }
                catch (Exception e) {
                    onInstallationSaveError.onInstallationSaveError(e);
                }
            }
        }, this.mInterval, TimeUnit.MILLISECONDS);
    }

    private long getLastAcceptedTimestamp() {
        return this.mPreferences.getLong(LAST_ACCEPTED_TIMESTAMP_KEY, Long.MIN_VALUE);
    }

    private int getLastAcceptedHash() {
        return this.mPreferences.getInt(LAST_ACCEPTED_HASH_KEY, 0);
    }
}

