/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.os.Build;
import android.util.Base64;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonObjectRequest;
import com.microsoft.windowsazure.messaging.notificationhubs.ConnectionString;
import com.microsoft.windowsazure.messaging.notificationhubs.Installation;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationAdapter;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationTemplate;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class InstallationPutRequest
extends JsonObjectRequest {
    private static final String API_VERSION = "2020-06";
    private static final long TOKEN_EXPIRE_SECONDS = 300L;
    private static final DateFormat sIso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ", Locale.ENGLISH);
    private final ConnectionString mConnectionString;

    public InstallationPutRequest(ConnectionString connectionString, String hubName, Installation installation, Response.Listener<JSONObject> onSuccess, Response.ErrorListener onFailure) {
        super(2, InstallationPutRequest.getInstallationUrl(connectionString.getEndpoint(), hubName, installation.getInstallationId()), InstallationPutRequest.getBody(installation), onSuccess, onFailure);
        this.mConnectionString = connectionString;
    }

    public Map<String, String> getHeaders() {
        try {
            HashMap<String, String> params = new HashMap<String, String>(){
                {
                    this.put("Content-Type", "application/json");
                    this.put("x-ms-version", InstallationPutRequest.API_VERSION);
                    this.put("Authorization", InstallationPutRequest.generateAuthToken(InstallationPutRequest.super.getUrl(), InstallationPutRequest.this.mConnectionString.getSharedAccessKeyName(), InstallationPutRequest.this.mConnectionString.getSharedAccessKey()));
                    this.put("User-Agent", InstallationPutRequest.getUserAgent());
                }
            };
            return params;
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        if (response.statusCode == 200) {
            return Response.success((Object)new JSONObject(), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        return super.parseNetworkResponse(response);
    }

    public static JSONObject getBody(final Installation installation) {
        final JSONArray tagList = new JSONArray();
        for (String string2 : installation.getTags()) {
            tagList.put((Object)string2);
        }
        try {
            final JSONObject serializedTemplates = new JSONObject();
            for (Map.Entry<String, InstallationTemplate> entry : installation.getTemplates().entrySet()) {
                String templateName = entry.getKey();
                serializedTemplates.put(templateName, (Object)InstallationTemplate.serialize(templateName, entry.getValue()));
            }
            JSONObject jSONObject = new JSONObject(){
                {
                    this.put("installationId", installation.getInstallationId());
                    this.put("platform", "GCM");
                    this.put("pushChannel", installation.getPushChannel());
                    this.put("tags", tagList);
                    this.put("templates", serializedTemplates);
                    this.put("userId", installation.getUserId());
                }
            };
            Date date = installation.getExpiration();
            if (date != null) {
                String formattedExpiration = sIso8601Format.format(date);
                jSONObject.put("expirationTime", (Object)formattedExpiration);
            }
            return jSONObject;
        }
        catch (JSONException e) {
            throw new UnsupportedOperationException("", e);
        }
    }

    public static <T> Response.Listener<T> wrapListener(final InstallationAdapter.Listener subject, final Installation installation) {
        return new Response.Listener<T>(){

            public void onResponse(T response) {
                subject.onInstallationSaved(installation);
            }
        };
    }

    public static Response.ErrorListener wrapErrorListener(final InstallationAdapter.ErrorListener errorListener) {
        return new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                errorListener.onInstallationSaveError((Exception)error);
            }
        };
    }

    private static String getUserAgent() {
        String userAgent = String.format("NOTIFICATIONHUBS/%s (api-origin=%s; os=%s; os_version=%s;)", API_VERSION, "AndroidSdkV1FcmV1.1.1", "Android", Build.VERSION.RELEASE);
        return userAgent;
    }

    static String getInstallationUrl(String endpoint, String hubName, String installationId) {
        String serviceBusProtocolIdentifier = "sb://";
        StringBuilder url = new StringBuilder();
        if (endpoint.startsWith("sb://")) {
            endpoint = endpoint.substring("sb://".length());
        }
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        url.append("https://").append(endpoint).append("/").append(hubName).append("/installations/").append(installationId).append("?api-version=").append(API_VERSION);
        return url.toString();
    }

    private static String generateAuthToken(String url, String sharedAccessKeyName, String sharedAccessKey) throws InvalidKeyException {
        try {
            url = URLEncoder.encode(url, "UTF-8").toLowerCase(Locale.ENGLISH);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        long expires = System.currentTimeMillis() / 1000L + 300L;
        String toSign = url + '\n' + expires;
        byte[] bytesToSign = toSign.getBytes();
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        SecretKeySpec secret = new SecretKeySpec(sharedAccessKey.getBytes(), mac.getAlgorithm());
        mac.init(secret);
        byte[] signedHash = mac.doFinal(bytesToSign);
        String base64Signature = Base64.encodeToString((byte[])signedHash, (int)0);
        base64Signature = base64Signature.trim();
        try {
            base64Signature = URLEncoder.encode(base64Signature, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "SharedAccessSignature sr=" + url + "&sig=" + base64Signature + "&se=" + expires + "&skn=" + sharedAccessKeyName;
    }
}

