/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ConnectionString {
    private static final Pattern PORTAL_FORMAT_PATTERN = Pattern.compile("(?<key>[^=]+)=(?<value>[^;]+);?");
    private static final String SHARED_ACCESS_KEY_NAME_KEY = "SharedAccessKeyName";
    private static final String ENDPOINT_KEY = "Endpoint";
    private static final String SHARED_ACCESS_KEY = "SharedAccessKey";
    private String mEndpoint;
    private String mSharedAccessKeyName;
    private String mSharedAccessKey;

    ConnectionString(String endpoint, String sharedAccessKeyName, String sharedAccessKey) {
        if (ConnectionString.isNullOrWhiteSpace(endpoint)) {
            throw new IllegalArgumentException("Endpoint parameter can not be null or empty");
        }
        if (ConnectionString.isNullOrWhiteSpace(sharedAccessKeyName)) {
            throw new IllegalArgumentException("SharedAccessKeyName parameter can not be null or empty");
        }
        if (ConnectionString.isNullOrWhiteSpace(sharedAccessKey)) {
            throw new IllegalArgumentException("SharedAccessKey parameter can not be null or empty");
        }
        this.mEndpoint = endpoint;
        this.mSharedAccessKeyName = sharedAccessKeyName;
        this.mSharedAccessKey = sharedAccessKey;
    }

    public static ConnectionString parse(String connectionString) {
        Matcher matcher = PORTAL_FORMAT_PATTERN.matcher(connectionString);
        String Endpoint = "";
        String SharedAccessKeyName = "";
        String SharedAccessKey = "";
        while (matcher.find()) {
            switch (matcher.group(1)) {
                case "Endpoint": {
                    Endpoint = matcher.group(2);
                    break;
                }
                case "SharedAccessKeyName": {
                    SharedAccessKeyName = matcher.group(2);
                    break;
                }
                case "SharedAccessKey": {
                    SharedAccessKey = matcher.group(2);
                }
            }
        }
        ConnectionString result = new ConnectionString(Endpoint, SharedAccessKeyName, SharedAccessKey);
        return result;
    }

    public String getEndpoint() {
        return this.mEndpoint;
    }

    public String getSharedAccessKeyName() {
        return this.mSharedAccessKeyName;
    }

    public String getSharedAccessKey() {
        return this.mSharedAccessKey;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConnectionString)) {
            return false;
        }
        ConnectionString cast = (ConnectionString)o;
        return this.mSharedAccessKey.equals(cast.mSharedAccessKey) && this.mSharedAccessKeyName.equals(cast.mSharedAccessKeyName) && this.mEndpoint.equalsIgnoreCase(cast.mEndpoint);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(ENDPOINT_KEY);
        builder.append('=');
        builder.append(this.mEndpoint);
        builder.append(';');
        builder.append(SHARED_ACCESS_KEY_NAME_KEY);
        builder.append('=');
        builder.append(this.mSharedAccessKeyName);
        builder.append(';');
        builder.append(SHARED_ACCESS_KEY);
        builder.append('=');
        builder.append(this.mSharedAccessKey);
        builder.append(';');
        return builder.toString();
    }

    private static boolean isNullOrWhiteSpace(String str) {
        return str == null || str.trim().equals("");
    }
}

