/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;

class NetworkStateHelper
implements Closeable {
    @SuppressLint(value={"StaticFieldLeak"})
    private static NetworkStateHelper sSharedInstance;
    private final Context mContext;
    private final ConnectivityManager mConnectivityManager;
    private final Set<Listener> mListeners = new CopyOnWriteArraySet<Listener>();
    private ConnectivityManager.NetworkCallback mNetworkCallback;
    private ConnectivityReceiver mConnectivityReceiver;
    private final AtomicBoolean mConnected = new AtomicBoolean();

    @VisibleForTesting
    public NetworkStateHelper(Context context) {
        this.mContext = context.getApplicationContext();
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.reopen();
    }

    public static synchronized void unsetInstance() {
        sSharedInstance = null;
    }

    public static synchronized NetworkStateHelper getSharedInstance(Context context) {
        if (sSharedInstance == null) {
            sSharedInstance = new NetworkStateHelper(context);
        }
        return sSharedInstance;
    }

    public void reopen() {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                NetworkRequest.Builder request = new NetworkRequest.Builder();
                request.addCapability(12);
                this.mNetworkCallback = new ConnectivityManager.NetworkCallback(){

                    public void onAvailable(Network network) {
                        NetworkStateHelper.this.onNetworkAvailable(network);
                    }

                    public void onLost(Network network) {
                        NetworkStateHelper.this.onNetworkLost(network);
                    }
                };
                this.mConnectivityManager.registerNetworkCallback(request.build(), this.mNetworkCallback);
            } else {
                this.mConnectivityReceiver = new ConnectivityReceiver();
                this.mContext.registerReceiver((BroadcastReceiver)this.mConnectivityReceiver, this.getOldIntentFilter());
                this.handleNetworkStateUpdate();
            }
        }
        catch (RuntimeException e) {
            Log.e((String)"ANH", (String)"Cannot access network state information.", (Throwable)e);
            this.mConnected.set(true);
        }
    }

    @NonNull
    private IntentFilter getOldIntentFilter() {
        return new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    }

    public boolean isNetworkConnected() {
        return this.mConnected.get() || this.isAnyNetworkConnected();
    }

    private boolean isAnyNetworkConnected() {
        if (Build.VERSION.SDK_INT >= 21) {
            Network[] networks = this.mConnectivityManager.getAllNetworks();
            if (networks == null) {
                return false;
            }
            for (Network network : networks) {
                NetworkInfo info = this.mConnectivityManager.getNetworkInfo(network);
                if (info == null || !info.isConnected()) continue;
                return true;
            }
        } else {
            NetworkInfo[] networks = this.mConnectivityManager.getAllNetworkInfo();
            if (networks == null) {
                return false;
            }
            for (NetworkInfo info : networks) {
                if (info == null || !info.isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    @RequiresApi(api=21)
    private void onNetworkAvailable(Network network) {
        Log.d((String)"ANH", (String)("Network " + network + " is available."));
        if (this.mConnected.compareAndSet(false, true)) {
            this.notifyNetworkStateUpdated(true);
        }
    }

    @RequiresApi(api=21)
    private void onNetworkLost(Network network) {
        boolean noNetwork;
        Log.d((String)"ANH", (String)("Network " + network + " is lost."));
        Object[] networks = this.mConnectivityManager.getAllNetworks();
        boolean bl = noNetwork = networks == null || networks.length == 0 || Arrays.equals(networks, new Network[]{network});
        if (noNetwork && this.mConnected.compareAndSet(true, false)) {
            this.notifyNetworkStateUpdated(false);
        }
    }

    private void handleNetworkStateUpdate() {
        boolean connected = this.isAnyNetworkConnected();
        if (this.mConnected.compareAndSet(!connected, connected)) {
            this.notifyNetworkStateUpdated(connected);
        }
    }

    private void notifyNetworkStateUpdated(boolean connected) {
        Log.d((String)"ANH", (String)("Network has been " + (connected ? "connected." : "disconnected.")));
        for (Listener listener : this.mListeners) {
            listener.onNetworkStateUpdated(connected);
        }
    }

    @Override
    public void close() {
        this.mConnected.set(false);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mConnectivityManager.unregisterNetworkCallback(this.mNetworkCallback);
        } else {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mConnectivityReceiver);
        }
    }

    public void addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    private class ConnectivityReceiver
    extends BroadcastReceiver {
        private ConnectivityReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            NetworkStateHelper.this.handleNetworkStateUpdate();
        }
    }

    public static interface Listener {
        public void onNetworkStateUpdated(boolean var1);
    }
}

