/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging.notificationhubs;

import android.content.Context;
import android.content.SharedPreferences;
import com.microsoft.windowsazure.messaging.R;
import com.microsoft.windowsazure.messaging.notificationhubs.Installation;
import com.microsoft.windowsazure.messaging.notificationhubs.InstallationVisitor;
import java.util.UUID;

class IdAssignmentVisitor
implements InstallationVisitor {
    private static final String PREFERENCE_KEY = "installationId";
    private final SharedPreferences mPreferences;

    public IdAssignmentVisitor(Context context) {
        this.mPreferences = context.getSharedPreferences(context.getString(R.string.installation_enrichment_file_key), 0);
    }

    @Override
    public void visitInstallation(Installation subject) {
        if (subject.getInstallationId() == null) {
            String id = this.getInstallationId();
            if (id == null) {
                id = UUID.randomUUID().toString();
                this.setInstallationId(id);
            }
            subject.setInstallationId(id);
        }
    }

    public String getInstallationId() {
        return this.mPreferences.getString(PREFERENCE_KEY, null);
    }

    public void setInstallationId(String installationId) {
        this.mPreferences.edit().putString(PREFERENCE_KEY, installationId).apply();
    }
}

