/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class ConnectionStringParser {
    private String _value;
    private int _pos;
    private ParserState _state;

    public static Map<String, String> parse(String connectionString) {
        ConnectionStringParser connectionStringParser = new ConnectionStringParser(connectionString);
        return connectionStringParser.parse();
    }

    private ConnectionStringParser(String value) {
        this._value = value;
        this._pos = 0;
        this._state = ParserState.EXPECT_KEY;
    }

    private Map<String, String> parse() {
        HashMap<String, String> result = new HashMap<String, String>();
        String key = null;
        String value = null;
        block5: while (true) {
            this.skipWhitespaces();
            if (this._pos == this._value.length() && this._state != ParserState.EXPECT_VALUE) break;
            switch (this._state) {
                case EXPECT_KEY: {
                    key = this.extractKey();
                    this._state = ParserState.EXPECT_ASSIGNMENT;
                    continue block5;
                }
                case EXPECT_ASSIGNMENT: {
                    this.skipOperator('=');
                    this._state = ParserState.EXPECT_VALUE;
                    continue block5;
                }
                case EXPECT_VALUE: {
                    value = this.extractValue();
                    this._state = ParserState.EXPECT_SEPARATOR;
                    result.put(key, value);
                    key = null;
                    value = null;
                    continue block5;
                }
            }
            this.skipOperator(';');
            this._state = ParserState.EXPECT_KEY;
        }
        if (this._state == ParserState.EXPECT_ASSIGNMENT) {
            throw this.createException(this._pos, "Missing character %s", "=");
        }
        return result;
    }

    private IllegalArgumentException createException(int position, String errorString, Object ... args) {
        errorString = String.format(errorString, args);
        errorString = String.format("Error parsing connection string: %s. Position %s", errorString, this._pos);
        errorString = String.format("Invalid connection string: %s.", errorString);
        return new IllegalArgumentException(errorString);
    }

    private void skipWhitespaces() {
        while (this._pos < this._value.length() && Character.isWhitespace(this._value.charAt(this._pos))) {
            ++this._pos;
        }
    }

    private String extractKey() {
        String text;
        char c;
        int pos = this._pos;
        if ((c = this._value.charAt(this._pos++)) == '\"' || c == '\'') {
            text = this.extractString(c);
        } else {
            if (c == ';' || c == '=') {
                throw this.createException(pos, "Missing key", new Object[0]);
            }
            while (this._pos < this._value.length() && (c = this._value.charAt(this._pos)) != '=') {
                ++this._pos;
            }
            text = this._value.substring(pos, this._pos).trim();
        }
        if (text.length() == 0) {
            throw this.createException(pos, "Empty key", new Object[0]);
        }
        return text;
    }

    private String extractString(char quote) {
        int pos = this._pos;
        while (this._pos < this._value.length() && this._value.charAt(this._pos) != quote) {
            ++this._pos;
        }
        if (this._pos == this._value.length()) {
            throw this.createException(this._pos, "Missing character", Character.valueOf(quote));
        }
        return this._value.substring(pos, this._pos++);
    }

    private void skipOperator(char operatorChar) {
        if (this._value.charAt(this._pos) != operatorChar) {
            throw this.createException(this._pos, "Missing character", Character.valueOf(operatorChar));
        }
        ++this._pos;
    }

    private String extractValue() {
        String result = "";
        if (this._pos < this._value.length()) {
            char c = this._value.charAt(this._pos);
            if (c == '\'' || c == '\"') {
                ++this._pos;
                result = this.extractString(c);
            } else {
                int pos = this._pos;
                boolean flag = false;
                while (this._pos < this._value.length() && !flag) {
                    c = this._value.charAt(this._pos);
                    char c2 = c;
                    if (c2 == ';') {
                        if (this.isStartWithKnownKey()) {
                            flag = true;
                            continue;
                        }
                        ++this._pos;
                        continue;
                    }
                    ++this._pos;
                }
                result = this._value.substring(pos, this._pos).trim();
            }
        }
        return result;
    }

    private boolean isStartWithKnownKey() {
        Locale defaultLocale = Locale.getDefault();
        return this._value.length() <= this._pos + 1 || this._value.substring(this._pos + 1).toLowerCase(defaultLocale).startsWith("endpoint") || this._value.substring(this._pos + 1).toLowerCase(defaultLocale).startsWith("stsendpoint") || this._value.substring(this._pos + 1).toLowerCase(defaultLocale).startsWith("sharedsecretissuer") || this._value.substring(this._pos + 1).toLowerCase(defaultLocale).startsWith("sharedsecretvalue") || this._value.substring(this._pos + 1).toLowerCase(defaultLocale).startsWith("sharedaccesskeyname") || this._value.substring(this._pos + 1).toLowerCase(defaultLocale).startsWith("sharedaccesskey");
    }

    private static enum ParserState {
        EXPECT_KEY,
        EXPECT_ASSIGNMENT,
        EXPECT_VALUE,
        EXPECT_SEPARATOR;

    }
}

